% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dk_funs.R
\name{a1_pk}
\alias{a1_pk}
\title{Recursion for a_{p,k}}
\usage{
a1_pk(L, mu = rep.int(0, n), m = 10L)
}
\arguments{
\item{L}{Eigenvalues of the argument matrix; vector of \eqn{\lambda_i}}

\item{mu}{Mean vector \eqn{\bm{\mu}} for \eqn{\mathbf{x}}}

\item{m}{Scalar to specify the desired order}
}
\description{
\code{a1_pk()} is an internal function to calculate \eqn{a_{p,k}}
(\eqn{a_{r,l}} in Hillier et al. 2014; eq. 24), which is used in the
calculation of the moment of such a ratio of quadratic forms in normal
variables where the denominator matrix is identity.
}
\details{
This function implements the super-short recursion described in
Hillier et al. (2014  eqs. 31--32).
Note that \eqn{w_{r,i}} there should be understood as \eqn{w_{r,l,i}} with
the index \eqn{l} fixed for each \eqn{a_{r,l}}.
}
\seealso{
\code{\link{qfrm_ApIq_int}()}, in which this function is used
(for noncentral cases only)
}
