% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_extensions.R
\name{mice.impute.leftcenslognorm}
\alias{mice.impute.leftcenslognorm}
\title{Imputation for limits of detection problems}
\usage{
mice.impute.leftcenslognorm(
  y,
  ry,
  x,
  wy = NULL,
  lod = NULL,
  debug = FALSE,
  ...
)
}
\arguments{
\item{y}{Vector to be imputed}

\item{ry}{Logical vector of length length(y) indicating the the subset y[ry] of elements in y to which the imputation model is fitted. The ry generally distinguishes the observed (TRUE) and missing values (FALSE) in y.}

\item{x}{Numeric design matrix with length(y) rows with predictors for y. Matrix x may have no missing values.}

\item{wy}{Logical vector of length length(y). A TRUE value indicates locations in y for which imputations are created.}

\item{lod}{numeric vector of limits of detection (must correspond to index in original data)}

\item{debug}{logical, print extra info}

\item{...}{arguments to \code{\link[survival]{survreg}}}
}
\value{
Vector with imputed data, same type as y, and of length sum(wy)
}
\description{
This function integrates with \code{\link[mice]{mice}} to impute values below the LOD using a left
censored log-normal distribution.
}
\details{
While this function has utility far beyond qgcomp,
it is included in the qgcomp package because it will be useful for a variety of
settings in which qgcomp is useful. Note that LOD problems where the LOD is small,
and the \code{q} parameter from \code{\link[qgcomp]{qgcomp.noboot}} or 
\code{\link[qgcomp]{qgcomp.boot}} is not large, the LOD may be below the lowest
quantile cutpoint which will yield identical datasets from the MICE procedure in terms
of quantized exposure data. If only exposures are missing, and they have low LODs, then
there will be no benefit in qgcomp from using MICE rather than imputing some small value 
below the LOD.
}
\examples{
N = 100
set.seed(123)
dat <- data.frame(y=runif(N), x1=runif(N), x2=runif(N), z=runif(N))
true = qgcomp.noboot(f=y ~ z + x1 + x2, expnms = c('x1', 'x2'), 
        data=dat, q=2, family=gaussian())
mdat <- dat
mdat$x1 = ifelse(mdat$x1>0.5, mdat$x1, NA)
mdat$x2 = ifelse(mdat$x2>0.75, mdat$x2, NA)
cc <- qgcomp.noboot(f=y ~ z + x1 + x2, expnms = c('x1', 'x2'), 
       data=mdat[complete.cases(mdat),], q=2, family=gaussian())

\donttest{
# note the following example imputes from the wrong parametric model and is expected to be biased
# as a result (but it demonstrates how to use qgcomp and mice together)
library("mice")
library("survival")
impdat = mice(data = mdat, 
  method = c("", "leftcenslognorm", "leftcenslognorm", ""),
  lod=c(NA, 0.5, 0.75, NA), debug=FALSE)
qc.fit.imp <- list(
  call = call("qgcomp.noboot(y~., expnms = c('x1', 'x2'), family=gaussian())"),
  call1 = impdat$call,
  nmis = impdat$nmis,
  analyses = lapply(1:5, function(x) qgcomp.noboot(y~., expnms = c("x1", "x2"),
    data=complete(impdat, x), family=gaussian(), bayes=TRUE))
)
obj = pool(as.mira(qc.fit.imp))
# true values
true
# complete case analysis
cc
# MI based analysis
summary(obj)
}
}
