% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/paretochart.R
\name{paretochart}
\alias{paretochart}
\title{Pareto chart}
\usage{
paretochart(x, main, ylab = "Frequency", xlab = "", cumperc.by = 20,
  cex = 0.9, ...)
}
\arguments{
\item{x}{Categorical vector to be plotted}

\item{main}{Plot title}

\item{ylab}{Label on first (left) y axis}

\item{xlab}{Label on x axis}

\item{cumperc.by}{Grid interval}

\item{cex}{Number indicating the amount by which text and symbols should be magnified.}

\item{...}{Further arguments to plot function}
}
\value{
A table of frequencies and percentages from the pareto analysis
}
\description{
Creates a pareto chart from a categorical variable
}
\examples{
x <- rep(LETTERS[1:9], c(200, 100, 50, 25, 12, 6, 3, 2, 1))
paretochart(x)
}
\author{
Jacob Anhoej
}

