% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/krige.R
\name{estim}
\alias{estim}
\alias{jacobian}
\title{Kriging prediction and estimation of derivatives}
\usage{
estim(models, points, Xs, data, krig.type = c("dual", "var", "both"))

jacobian(models, points, Xs, data, krig.type = c("dual", "var", "both"))
}
\arguments{
\item{models}{object of class \code{krige} either as a list of covariance models or
class `\code{covModel}` as a single covariance model, see \code{\link{setCovModel}}}

\item{points}{matrix or list of points to predict the sample means of statistics}

\item{Xs}{matrix of sample points}

\item{data}{data frame of sample means of statistics at sampled points}

\item{krig.type}{name of kriging type, either "\code{dual}" (default) or "\code{var}"}
}
\value{
\item{estim}{ list of predicted values of sample means of statistics (including prediction
		 variances if `\code{krig.type}` equals to "\code{var}")}
 \item{jacobian}{ list of Jacobians at predicted values of sample means of statistics}
}
\description{


Jacobian of mean values of statistics
}
\details{
The function can be used to predict any values by kriging given a covariance model. In particular, we use it to predict
 the sample mean of any statistic. Each covariance model is given as an element of the list `\code{models}` including its own trend
 model and covariance function name. There are two types of kriging predictors available. First, the \emph{dual kriging} predictor,
 set by `\code{krig.type}`="\code{dual}" or the one based on the calculation of prediction variances, if `\code{krig.type}` equals
 "\code{var}". Both result in exactly the same predicted values and only differ by whether or not kriging variances are calculated.
 The measurements (data), e.g. sample means for each statistic, must be given as column vectors where each row corresponds to a
 sample point in the data frame `\code{data}`.

The function `\code{jacobian}` computes the partial derivatives of sample means of the statistics
  as columns and for each component of the parameter vector as rows by forward differences.
}
\examples{
data(normal) 

X <- as.matrix(qsd$qldata[,1:2])
p <- c("mu"=2,"sd"=1)

# get simulated statistics at design X
Tstat <- qsd$qldata[grep("^mean.",names(qsd$qldata))]

# low level prediction, variances and weights
estim(qsd$covT,p,X,Tstat,krig.type="var")

# Jacobian 
jacobian(qsd$covT,p,X,Tstat)
 
   
}
\author{
M. Baaske
}
