% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qsOpt.R
\name{prefitCV}
\alias{prefitCV}
\title{Covariance parameter estimation for cross-validation}
\usage{
prefitCV(qsd, reduce = TRUE, type = c("cv", "max"), control = list(),
  cl = NULL, verbose = FALSE)
}
\arguments{
\item{qsd}{object of class \code{\link{QLmodel}}}

\item{reduce}{if \code{TRUE} (default), reduce the number of covariance models to refit}

\item{type}{type of prediction variances, "\code{cv}" (default), see \code{\link{qle}}}

\item{control}{control arguments for REML estimation passed to \code{\link[nloptr]{nloptr}}}

\item{cl}{cluster object, \code{NULL} (default), see \code{\link[parallel]{makeCluster}}}

\item{verbose}{if \code{TRUE}, print intermediate output}
}
\value{
A list of certain length depending on the current sample size (number of evaluated points).
 Each list element corresponds to a (reduced) number of sample points with at most \eqn{k} points
 (see details) left out for fitting the covariance models.
}
\description{
The function constructs a list of covariance models of statistics in order to estimate the prediction error
 variances by a cross-validation (CV) approach at unsampled points.
}
\details{
Using the CV-based approach (see vignette) for estimating the prediction variances 
	might require a refit of covariance parameters of each statistic based on leaving out a certain number of sample points.
 The covariance models can be refitted if `\code{fit}` equals \code{TRUE} and otherwise are simply updated without fitting which
 saves some computational resources. The number of points left out is dynamically adjusted depending on the number
 of sample points in order to prevent the main estimation algorithm to fit as many models as there are points already evaluated.  

 For CV the number \eqn{n_c} of covariance models still to fit, that is, the number of partitioning sets of sample points, is limited by
 \eqn{n_c\leq n}, with maximum \eqn{k} sampling points deleted from the full sample set with overall \eqn{n} sample points such that
 \eqn{n=n_c k} (see vignette for further details).
}
\examples{
  data(normal)
  
  # without re-estimation of covariance parameters, default is TRUE
  qsd$cv.fit <- FALSE  
  cvm <- prefitCV(qsd)
  
}
\seealso{
\code{\link{QLmodel}}
}
\author{
M. Baaske
}
