% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ECBC.R
\name{pure_r_ECBC}
\alias{pure_r_ECBC}
\title{Compute empirical checkerboard copula in arbitrary dimension}
\usage{
pure_r_ECBC(X, Y, resolution)
}
\arguments{
\item{X}{a numeric matrix of dimension d indicating the conditioning (predictor) variables}

\item{Y}{a numeric vector indicating the response variable}

\item{resolution}{an integer indicating the resolution N of the checkerboard copula.}
}
\value{
array of dimension dim(X,Y).
}
\description{
The function ECBC computes the mass distribution of the empirical (checkerboard) copula, 
given a (d+1)-dimensional sample (X,Y). If resolution equals sample size, the bi-linearly extended empirical copula is returned. 
Note, if there are ties in the sample an adjusted empirical copula is calculated.
}
\examples{
n <- 1000
x1 <- runif(n)
x2 <- runif(n)
y <- x1 + x2 + rnorm(n)
M <- pure_r_ECBC(X = cbind(x1,x2), Y = y, resolution = 8)

}
