% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_qq_band.R, R/stat_qq_band.R
\name{geom_qq_band}
\alias{geom_qq_band}
\alias{stat_qq_band}
\title{Quantile-quantile confidence bands}
\usage{
geom_qq_band(data = NULL, mapping = NULL, stat = "qq_band",
  position = "identity", show.legend = NA, inherit.aes = TRUE,
  na.rm = TRUE, distribution = "norm", dparams = list(),
  detrend = FALSE, identity = FALSE, qtype = 7, qprobs = c(0.25, 0.75),
  bandType = "pointwise", B = 1000, conf = 0.95, mu = NULL,
  sigma = NULL, ...)

stat_qq_band(data = NULL, mapping = NULL, geom = "qq_band",
  position = "identity", show.legend = NA, inherit.aes = TRUE,
  na.rm = TRUE, distribution = "norm", dparams = list(),
  detrend = FALSE, identity = FALSE, qtype = 7, qprobs = c(0.25, 0.75),
  bandType = "pointwise", B = 1000, conf = 0.95, mu = NULL,
  sigma = NULL, ...)
}
\arguments{
\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame.}, and
will be used as the layer data.}

\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{stat}{statistic to use to calculate confidence bands. Should be
`qq_band`.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{distribution}{Character. Theoretical probability distribution function
to use. Do not provide the full distribution function name (e.g.,
\code{"dnorm"}). Instead, just provide its shortened name (e.g.,
\code{"norm"}). If you wish to provide a custom distribution, you may do so
by first creating the density, quantile, and random functions following the
standard nomenclature from the \code{stats} package (i.e., for
\code{"custom"}, create the \code{dcustom}, \code{pcustom},
\code{qcustom}, and \code{rcustom} functions).}

\item{dparams}{List of additional parameters passed on to the previously
chosen \code{distribution} function. If an empty list is provided (default)
then the distributional parameters are estimated via MLE. MLE for custom
distributions is currently not supported, so you must provide the
appropriate \code{dparams} in that case.}

\item{detrend}{Logical. Should the plot objects be detrended? If \code{TRUE},
the objects will be detrended according to the reference Q-Q line. This
procedure was described by Thode (2002), and may help reducing visual bias
caused by the orthogonal distances from Q-Q points to the reference line.}

\item{identity}{Logical. Should an identity line be used as the reference
line used to construct the confidence bands? If \code{TRUE}, the identity
line is used. If \code{FALSE} (default), the commonly-used Q-Q line that
intercepts two data quantiles specified in \code{qprobs} is used. Please
notice that the chosen reference line will also be used for the detrending
procedure, if \code{detrend = TRUE}.}

\item{qtype}{Integer between 1 and 9. Type of the quantile algorithm to be
used by the \code{\link[stats]{quantile}} function to construct the Q-Q
line.}

\item{qprobs}{Numeric vector of length two. Represents the quantiles used by
the \code{\link[stats]{quantile}} function to construct the Q-Q line.}

\item{bandType}{Character. Either \code{"pointwise"}, \code{"boot"}, \code{"ks"} or
\code{"ts"}. \code{"pointwise"} constructs pointwise confidence bands based
on Normal confidence intervals. \code{"boot"} creates pointwise confidence
bands based on a parametric bootstrap; parameters are estimated with MLEs.
\code{"ks"} constructs simultaneous confidence bands based on the Kolmogorov-Smirnov
test. Finally, \code{"ts"} constructs tail-sensitive confidence bands, as
described by Aldor-Noiman et al. (2013) (also, see 'Note' for
limitations).}

\item{B}{Integer. If \code{bandType = "boot"}, then \code{B} is the number of
bootstrap replicates. If \code{bandType = "ts"}, then \code{B} is the
number of simulated samples.}

\item{conf}{Numerical. Confidence level of the bands.}

\item{mu}{Numerical. Only used if \code{bandType = "ts"}. Center
distributional parameter used to construct the simulated tail-sensitive
confidence bands. If either \code{mu} or \code{sigma} are \code{NULL}, then
those parameters are estimated using \code{\link[robustbase]{Qn}} and
\code{\link[robustbase:Qn]{robustbase::s_Qn()}}, respectively.}

\item{sigma}{Numerical. Only used if \code{bandType = "ts"}. Scale
distributional parameter used to construct the simulated tail-sensitive
confidence bands. If either \code{mu} or \code{sigma} are \code{NULL}, then
those parameters are estimated using robust estimates from the \pkg{stats}
package.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{geom}{The geometric object to use display the data}
}
\description{
Draws quantile-quantile confidence bands, with an additional detrend option.
}
\note{
\itemize{
\item{Tail-sensitive confidence bands are only implemented for Normal Q-Q
plots. As a future update, we intend to generalize to other distributions.}
\item{Bootstrap bands are constructed based on a MLE parametric bootstrap.
Hence, it is not possible to construct such bands if the sample and
theoretical distributions present mismatching supports.}
}
}
\examples{
# generate random Normal data
set.seed(0)
smp <- data.frame(norm = rnorm(100))

# Normal Q-Q plot of Normal data
gg <- ggplot(data = smp, mapping = aes(sample = norm)) +
 stat_qq_band() +
 stat_qq_line() +
 stat_qq_point()
gg + labs(x = "Theoretical Quantiles", y = "Sample Quantiles")

# Exponential Q-Q plot of mean ozone levels (airquality dataset)
di <- "exp"
dp <- list(rate = 1)
gg <- ggplot(data = airquality, mapping = aes(sample = Ozone)) +
 stat_qq_band(distribution = di, dparams = dp) +
 stat_qq_line(distribution = di, dparams = dp) +
 stat_qq_point(distribution = di, dparams = dp) +
 labs(x = "Theoretical Quantiles", y = "Sample Quantiles")
gg

# Detrended Exponential Q-Q plot of mean ozone levels
di <- "exp"
dp <- list(rate = 1)
de <- TRUE
gg <- ggplot(data = airquality, mapping = aes(sample = Ozone)) +
 stat_qq_band(distribution = di, detrend = de) +
 stat_qq_line(distribution = di, detrend = de) +
 stat_qq_point(distribution = di, detrend = de) +
 labs(x = "Theoretical Quantiles", y = "Sample Quantiles")
gg

# Normal Q-Q plot of Normal data with boostrap confidence bands
bt <- "boot"
gg <- ggplot(data = smp, mapping = aes(sample = norm)) +
 stat_qq_band(bandType = bt) +
 stat_qq_line() +
 stat_qq_point() +
 labs(x = "Theoretical Quantiles", y = "Sample Quantiles")
gg

# Normal Q-Q plot of Normal data with tail-sensitive confidence bands
bt <- "ts"
gg <- ggplot(data = smp, mapping = aes(sample = norm)) +
 stat_qq_band(bandType = bt) +
 stat_qq_line() +
 stat_qq_point() +
 labs(x = "Theoretical Quantiles", y = "Sample Quantiles")
gg

}
\references{
\itemize{
\item{\href{https://www.crcpress.com/Testing-For-Normality/Thode/p/book/9780824796136}{Thode,
H. (2002), Testing for Normality. CRC Press, 1st Ed.}}
\item{\href{http://www.tandfonline.com/doi/abs/10.1080/00031305.2013.847865}{Aldor-Noiman,
S. et al. (2013). The Power to See: A New Graphical Test of Normality. The
American Statistician. 67:4.}}
}
}
