% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help_files.R
\name{zstd_compress_raw}
\alias{zstd_compress_raw}
\title{Zstd compression}
\usage{
zstd_compress_raw(x, compress_level)
}
\arguments{
\item{x}{A Raw Vector}

\item{compress_level}{The compression level (-50 to 22)}
}
\value{
The compressed data
}
\description{
Compression of raw vector.  Exports the main zstd compression function.
}
\examples{
x <- 1:1e6
xserialized <- serialize(x, connection=NULL)
xcompressed <- zstd_compress_raw(xserialized, compress_level = 1)
xrecovered <- unserialize(zstd_decompress_raw(xcompressed))
}
