% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qx_functions.R
\name{zstd_compress_raw}
\alias{zstd_compress_raw}
\title{Zstd compression}
\usage{
zstd_compress_raw(data, compress_level)
}
\arguments{
\item{data}{Raw vector to be compressed.}

\item{compress_level}{The compression level used.}
}
\value{
The compressed data as a raw vector.
}
\description{
Compresses to a raw vector using the zstd algorithm. Exports the main zstd compression function.
}
\examples{
x <- 1:1e6
xserialized <- serialize(x, connection=NULL)
xcompressed <- zstd_compress_raw(xserialized, compress_level = 1)
xrecovered <- unserialize(zstd_decompress_raw(xcompressed))
}
