% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groebner.R
\name{qdivision}
\alias{qdivision}
\title{Division of a qspray polynomial}
\usage{
qdivision(qspray, divisors, check = TRUE)
}
\arguments{
\item{qspray}{the dividend, a \code{qspray} object}

\item{divisors}{the divisors, a list of \code{qspray} objects}

\item{check}{Boolean, whether to check the division; this argument will be 
removed in a future version}
}
\value{
The remainder of the division, a \code{qspray} object. Moreover, 
  if \code{qspray} is univariate, the quotient is attached to the remainder 
  as an attribute.
}
\description{
Division of a qspray polynomial by a list of qspray 
  polynomials. See the reference for the definition.
}
\examples{
# a univariate example
library(qspray)
x <- qlone(1)
f <- x^4 - 4*x^3 + 4*x^2 - x # 0 and 1 are trivial roots
g <- x * (x - 1)
( r <- qdivision(f, list(g)) ) # should be zero
attr(r, "quotient")
}
\references{
Michael Weiss, 2010. 
\href{https://math.nyu.edu/degree/undergrad/ug_research/Weiss_SURE_Paper.pdf}{Computing Gröbner Bases in Python with Buchberger’s Algorithm}.
}
