% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{collinearQsprays}
\alias{collinearQsprays}
\title{Whether two 'qspray' polynomials are collinear}
\usage{
collinearQsprays(qspray1, qspray2)
}
\arguments{
\item{qspray1, qspray2}{two \code{qspray} objects}
}
\value{
A Boolean value.
}
\description{
Checks whether the polynomials represented by two \code{qspray}
  objects are collinear, that is, whether they are equal up to a scalar 
  factor.
}
\examples{
library(qspray)
qspray1 <- qsprayMaker(string = "1/2 x^(1, 1) + 4 x^(0, 2) + 5")
qspray2 <- "4/7" * qspray1
collinearQsprays(qspray1, qspray2)
}
