% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qte.R
\name{compute.panel.qtet}
\alias{compute.panel.qtet}
\title{compute.panel.qte}
\usage{
compute.panel.qtet(formla, xformla = NULL, t, tmin1, tmin2, tname, x = NULL,
  data, dropalwaystreated = TRUE, idname, probs = seq(0.05, 0.95, 0.05),
  bootstrap.iter = FALSE, plot = FALSE, method = c("logit", "GMM",
  "semiparametric", "simulation", "direct"), ydiscrete = FALSE)
}
\arguments{
\item{formla}{outcome variable on treatment}

\item{t}{last time period}

\item{tmin1}{middle time period}

\item{tmin2}{initial time period}

\item{x}{additional covariates if using propensity score
reweighting technique}

\item{dropalwaystreated}{boolean indicating whether in true panel data
context (when treatment can occur in any period) whether or
not previously treated observations should be dropped from the sample.
This functionality is not currently implemented}

\item{idname}{an id that identifies individual units over time}

\item{probs}{the values at which the quantile treatment effects
should be computed}

\item{bootstrap.iter}{boolean passed that is passed in when this
method is used to compute standard errors}

\item{plot}{Binary indicating whether or not to plot the object}

\item{method}{How to estimate the propensity score}

\item{ydiscrete}{Used to indicate whether the outcome has any
discrete parts in the distribution}
}
\value{
QTE object
}
\description{
\code{compute.panel.qte} uses third period of data,
combined with Distributional
Difference in Differences assumption (Fan and Yu, 2012)
to point identify QTET.
}
\keyword{internal}
