% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mat2strata.R
\name{mat2strata}
\alias{mat2strata}
\title{Define strata based on rows of a matrix}
\usage{
mat2strata(mat)
}
\arguments{
\item{mat}{A covariate matrix, as individuals x covariates}
}
\value{
A vector of character strings: for each row of \code{mat},
we use \code{\link[base:paste]{base::paste()}} with \code{collapse="|"}.
}
\description{
Use the rows of a matrix to define a set of strata for a stratified permutation test
}
\examples{
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))

Xcovar <- get_x_covar(iron)
perm_strata <- mat2strata(Xcovar)

}
\seealso{
\code{\link[=get_x_covar]{get_x_covar()}}, \code{\link[=scan1perm]{scan1perm()}}
}
