% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_gmap.R
\name{smooth_gmap}
\alias{smooth_gmap}
\title{Smooth genetic map}
\usage{
smooth_gmap(gmap, pmap, alpha = 0.02)
}
\arguments{
\item{gmap}{Genetic map, as a list of numeric vectors; each vector gives marker
positions for a single chromosome.}

\item{pmap}{Physical map, as a list of numeric vectors; each vector gives marker
positions for a single chromosome, with the same chromosomes and markers as \code{gmap}.}

\item{alpha}{Proportion of mixture to take from constant recombination.}
}
\value{
A genetic map like the input \code{gmap}, but smoothed by mixing
it with a proportion \code{alpha} of constant recombination on each
chromosome.
}
\description{
Smooth a genetic map by mixing it with a bit of constant
recombination (using a separate recombination rate for each
chromosome), to eliminate intervals that have exactly 0
recombination.
}
\details{
An interval of genetic length \eqn{d_g}{dg} and physical
length \eqn{d_p}{dp} is changed to have length
\eqn{(1-\alpha)d_g + \alpha d_p r}{(1-alpha)dg + (alpha*dp*r)}
where \eqn{r = L_g / L_p}{r = Lg/Lp} is the chromosome-specific
recombination rate.
}
\examples{
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))
gmap_adj <- smooth_gmap(iron$gmap, iron$pmap)

}
\seealso{
\code{\link[=unsmooth_gmap]{unsmooth_gmap()}}
}
\keyword{utilities}
