% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbind_smother.R
\name{cbind_smother}
\alias{cbind_smother}
\title{Combine matrices by columns, replacing matching ones and adding unique ones}
\usage{
cbind_smother(mat1, mat2)
}
\arguments{
\item{mat1}{A matrix}

\item{mat2}{Another matrix, with the same number of rows as \code{mat}.}
}
\value{
The two matrices combined by columns, but columns in the
first matrix that also appear in the second matrix are deleted
and replaced by those in the second matrix. Uses the row names
to align the rows in the two matrices, and to expand them as needed.
}
\description{
This is like \code{\link[base:cbind]{base::cbind()}} but if a column in the second matrix
has the same name as a column in the first matrix, the column in
the first matrix is deleted and that in the second matrix is used
in its place.
}
\examples{
df1 <- data.frame(x=c(1,2,3,NA,4), y=c(5,8,9,10,11), row.names=c("A", "B", "C", "D", "E"))
df2 <- data.frame(z=c(7,8,0,9,10), y=c(6,NA,NA,9,10), row.names=c("A", "B", "F", "C", "D"))
df1n2 <- cbind_smother(df1, df2)
}
