% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_coef.R
\name{ggplot_coef}
\alias{ggplot_coef}
\alias{ggplot_coefCC}
\alias{autoplot.scan1coef}
\title{Plot QTL effects along chromosome}
\usage{
ggplot_coef(
  object,
  map,
  columns = NULL,
  col = NULL,
  scan1_output = NULL,
  gap = 25,
  ylim = NULL,
  bgcolor = "gray90",
  altbgcolor = "gray85",
  ylab = "QTL effects",
  xlim = NULL,
  ...
)

ggplot_coefCC(object, map, colors = qtl2::CCcolors, ...)

\method{autoplot}{scan1coef}(object, ...)
}
\arguments{
\item{object}{Estimated QTL effects ("coefficients") as obtained from
\code{\link[qtl2]{scan1coef}}.}

\item{map}{A list of vectors of marker positions, as produced by
\code{\link[qtl2]{insert_pseudomarkers}}.}

\item{columns}{Vector of columns to plot}

\item{col}{Vector of colors, same length as \code{columns}. If
NULL, some default choices are made.}

\item{scan1_output}{If provided, we make a two-panel plot with
coefficients on top and LOD scores below. Should have just one LOD
score column; if multiple, only the first is used.}

\item{gap}{Gap between chromosomes.}

\item{ylim}{y-axis limits. If \code{NULL}, we use the range of the plotted
coefficients.}

\item{bgcolor}{Background color for the plot.}

\item{altbgcolor}{Background color for alternate chromosomes.}

\item{ylab}{y-axis label}

\item{xlim}{x-axis limits. If \code{NULL}, we use the range of the plotted
coefficients.}

\item{...}{Additional graphics parameters.}

\item{colors}{Colors to use for plotting.}
}
\value{
object of class \code{\link[ggplot2]{ggplot}}.
}
\description{
Plot estimated QTL effects along a chromosomes.
}
\details{
\code{ggplot_coefCC()} is the same as \code{ggplot_coef()}, but forcing
\code{columns=1:8} and using the Collaborative Cross colors,
\code{\link[qtl2]{CCcolors}}.
}
\examples{
# read data
iron <- qtl2::read_cross2(system.file("extdata", "iron.zip", package="qtl2"))

# insert pseudomarkers into map
map <- qtl2::insert_pseudomarkers(iron$gmap, step=1)

# calculate genotype probabilities
probs <- qtl2::calc_genoprob(iron, map, error_prob=0.002)

# grab phenotypes and covariates; ensure that covariates have names attribute
pheno <- iron$pheno[,1]
covar <- match(iron$covar$sex, c("f", "m")) # make numeric
names(covar) <- rownames(iron$covar)

# calculate coefficients for chromosome 7
coef <- qtl2::scan1coef(probs[,7], pheno, addcovar=covar)

# plot QTL effects
ggplot2::autoplot(coef, map[7], columns=1:3)

}
\seealso{
\code{\link{ggplot_scan1}}, \code{\link{ggplot_snpasso}}
}
