% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_data.R
\name{add_data}
\alias{add_data}
\title{Add data to existing data frame.}
\usage{
add_data(data, add, cols, data_id, add_id, number = FALSE)
}
\arguments{
\item{data}{A data frame you want to add columns to.}

\item{add}{A data frame with columns you want to add to \code{data}.}

\item{cols}{The column names from \code{add} that you wish to add to \code{data}.}

\item{data_id}{The ID column in \code{data} that will be used to match rows in \code{add}.}

\item{add_id}{The ID column in \code{add} that will be used to match rows in \code{data}.}

\item{number}{The column number to start at to add the new columns, so they
are not added to the end of the data frame. If not specified they will
be added to the end of the data frame by default.}
}
\value{
A data frame with added columns.
}
\description{
Using key identifying columns, add additional columns to an
existing data frame. This function allows you to match new columns
based on specified IDs and you can choose what columns to add. Additionally
you can specify the column number at which to add the new columns, so they
are not added to the end of the data frame. Helpful for adding environmental
or taxonomic data to your quadrat data.
}
\examples{
Sites <- as.factor(c("One", "One", "One", "Two", "Two", "Three"))
Transect <- as.factor(c("1-Deep", "1-Shallow", "2-Shallow", "1-Shallow", "1-Deep", "1"))
coral_name <- c("Acropora.sp", "Leptastrea.sp", "Sinularia.sp", "Psammocora.sp", "
    Psammocora.sp", "Leptastrea.sp")
prop_cover <- c(0.1, 0.6, 0.4, 0.9, 0.2, 0.5)
coral_cover <- data.frame(Sites, Transect, coral_name, prop_cover)

corals <- c("Acropora.sp", "Leptastrea.sp", "Psammocora.sp")
lifehistory <- c("compeditive", "weedy",  "stresstolerant")
functionalgroup <- c("hardcoral", "hardcoral", "hardcoral")
coral_info <- data.frame(corals, lifehistory, functionalgroup)

add_data(data = coral_cover, add = coral_info, cols = c("lifehistory", "functionalgroup"),
         data_id = "coral_name", add_id = "corals", number = 4)

}
