% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcp.R
\name{lcp_finder}
\alias{lcp_finder}
\alias{lcp_finder,Quadtree,numeric-method}
\title{Create a \code{LcpFinder}}
\usage{
\S4method{lcp_finder}{Quadtree,numeric}(x, y, xlim = NULL, ylim = NULL, search_by_centroid = FALSE)
}
\arguments{
\item{x}{a \code{\link{Quadtree}} to be used as a resistance surface}

\item{y}{two-element numeric vector (x, y) - the x and y coordinates of the
starting point}

\item{xlim}{two-element numeric vector (xmin, xmax) - constrains the nodes
included in the network to those whose x limits fall in the range specified
in \code{xlim}. If \code{NULL} the x limits of \code{x} are used}

\item{ylim}{same as \code{xlim}, but for y}

\item{search_by_centroid}{boolean; determines which cells are considered to
be "in" the box specified by \code{xlim} and \code{ylim}. If \code{FALSE}
(the default) any cell that overlaps with the box is included. If
\code{TRUE}, a cell is only included if its \strong{centroid} falls inside
the box.}
}
\value{
a \code{\link{LcpFinder}}
}
\description{
Creates a \code{\link{LcpFinder}} object that can then be used
  by \code{\link{find_lcp}} and \code{\link{find_lcps}} to find least-cost
  paths (LCPs) using a \code{\link{Quadtree}} as a resistance surface.
}
\details{
See the vignette 'quadtree-lcp' for more details and examples (i.e. run
  \code{vignette("quadtree-lcp", package = "quadtree")})
}
\examples{
####### NOTE #######
# see the "quadtree-lcp" vignette for more details and examples:
# vignette("quadtree-lcp", package = "quadtree")
####################

library(quadtree)

data(habitat)
qt <- quadtree(habitat, split_threshold = .1, adj_type = "expand")

# find the LCP between two points
start_pt <- c(6989, 34007)
end_pt <- c(33015, 38162)

# create the LCP finder object and find the LCP
lcpf <- lcp_finder(qt, start_pt)
path <- find_lcp(lcpf, end_pt)

# plot the LCP
plot(qt, crop = TRUE, na_col = NULL, border_lwd = .3)
points(rbind(start_pt, end_pt), pch = 16, col = "red")
lines(path[, 1:2], col = "black")
}
\seealso{
\code{\link{find_lcp}()} returns the LCP between the start point and
  another point. \code{\link{find_lcps}()} finds all LCPs whose cost-distance
  is less than some value. \code{\link{summarize_lcps}()} outputs a summary
  matrix of all LCPs that have been calculated so far.
  \code{\link[=plot.LcpFinder]{points}()} and
  \code{\link[=plot.LcpFinder]{lines}()} can be used to plot a
  \code{\link{LcpFinder}}.
}
