% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imageWithLabels.R
\name{imageWithLabels}
\alias{imageWithLabels}
\title{image plot with labels}
\usage{
imageWithLabels(x, col.labels = colnames(x), row.labels = rownames(x),
  cex = 1, cex.axis = 0.5, main = NULL, col = heat.colors(12),
  digits = 2, marLeft = graphics::par()$mar,
  marRight = graphics::par()$mar, xlab = "", ylab = "", zlim = NULL,
  na.color = "gray", widths = c(4, 1), ...)
}
\arguments{
\item{x}{matrix}

\item{col.labels}{rownames(x)}

\item{row.labels}{colnames(x)}

\item{cex}{size of labels}

\item{cex.axis}{size of axis lables}

\item{main}{main title}

\item{col}{color map for matrix}

\item{digits}{number of digits on colorscale, default 2}

\item{marLeft}{margins of left image see ?par for more detail}

\item{marRight}{margins of right image see ?par for more detail}

\item{xlab}{x label}

\item{ylab}{y label}

\item{zlim}{z value range, default NULL an determined from x}

\item{na.color}{na.color}

\item{widths}{controls the size of left and right pane}

\item{...}{passed to image}
}
\description{
image plot with labels
}
\examples{
x = matrix(rnorm(20*30),ncol=20)
rownames(x) <- 1:30
colnames(x) <- letters[1:20]
martmp <- par()$mar
imageWithLabels(x)
imageWithLabels(x,marLeft = c(5,5,2,2),marRight=c(0,0,0,0),xlab="ttt",ylab="bbb")
par(mar = martmp)

}
