% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dfm-classes.R
\name{head.dfm}
\alias{head.dfm}
\alias{tail.dfm}
\title{Return the first or last part of a dfm}
\usage{
\method{head}{dfm}(x, n = 6L, nfeature = 6L, ...)

\method{tail}{dfm}(x, n = 6L, nfeature = 6L, ...)
}
\arguments{
\item{x}{a dfm object}

\item{n}{a single integer.  If positive, size for the resulting object:
number of first/last documents for the dfm. If negative, all but the n
last/first number of documents of x.}

\item{nfeature}{the number of features to return, where the resulting object
will contain the first \code{ncol} features}

\item{...}{arguments to be passed to or from other methods.}
}
\value{
A \link{dfm-class} class object corresponding to the subset defined
  by \code{n} and \code{ncol}.

A \link{dfm-class} class object corresponding to the subset
  defined by \code{n} and \code{ncol}.
}
\description{
For a \link{dfm-class} object, returns the first or last \code{n} documents
and first \code{ncol} features for inspection.
}
\examples{
myDfm <- dfm(inaugCorpus, ngrams = 2, verbose = FALSE)
head(myDfm)
tail(myDfm)
tail(myDfm, nfeature = 4)
}

