% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfm-classes.R
\docType{class}
\name{dfm-class}
\alias{+,dfmDense,numeric-method}
\alias{+,dfmSparse,numeric-method}
\alias{+,numeric,dfmDense-method}
\alias{+,numeric,dfmSparse-method}
\alias{[,dfmDense,index,index,logical-method}
\alias{[,dfmDense,index,index,missing-method}
\alias{[,dfmDense,index,missing,logical-method}
\alias{[,dfmDense,index,missing,missing-method}
\alias{[,dfmDense,logical,missing,missing-method}
\alias{[,dfmDense,missing,index,logical-method}
\alias{[,dfmDense,missing,index,missing-method}
\alias{[,dfmDense,missing,missing,logical-method}
\alias{[,dfmDense,missing,missing,missing-method}
\alias{[,dfmSparse,index,index,logical-method}
\alias{[,dfmSparse,index,index,missing-method}
\alias{[,dfmSparse,index,missing,logical-method}
\alias{[,dfmSparse,index,missing,missing-method}
\alias{[,dfmSparse,logical,missing,missing-method}
\alias{[,dfmSparse,missing,index,logical-method}
\alias{[,dfmSparse,missing,index,missing-method}
\alias{[,dfmSparse,missing,missing,logical-method}
\alias{[,dfmSparse,missing,missing,missing-method}
\alias{as.data.frame,dfm-method}
\alias{as.matrix,dfm-method}
\alias{cbind.dfm}
\alias{colMeans,dfmSparse-method}
\alias{colSums,dfmSparse-method}
\alias{dfm-class}
\alias{dfmDense-class}
\alias{dfmSparse-class}
\alias{rowMeans,dfmSparse-method}
\alias{rowSums,dfmSparse-method}
\alias{t,dfmDense-method}
\alias{t,dfmSparse-method}
\title{Virtual class "dfm" for a document-feature matrix}
\usage{
\S4method{t}{dfmDense}(x)

\S4method{t}{dfmSparse}(x)

\S4method{colSums}{dfmSparse}(x, na.rm = FALSE, dims = 1L, ...)

\S4method{rowSums}{dfmSparse}(x, na.rm = FALSE, dims = 1L, ...)

\S4method{colMeans}{dfmSparse}(x, na.rm = FALSE, dims = 1L, ...)

\S4method{rowMeans}{dfmSparse}(x, na.rm = FALSE, dims = 1L, ...)

\S4method{[}{dfmDense,index,index,missing}(x, i = NULL, j = NULL, ...,
  drop = FALSE)

\S4method{[}{dfmDense,index,index,logical}(x, i = NULL, j = NULL, ...,
  drop = FALSE)

\S4method{[}{dfmDense,index,missing,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{dfmDense,logical,missing,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{dfmDense,index,missing,logical}(x, i, j, ..., drop = FALSE)

\S4method{[}{dfmDense,missing,index,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{dfmDense,missing,index,logical}(x, i, j, ..., drop = FALSE)

\S4method{[}{dfmDense,missing,missing,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{dfmDense,missing,missing,logical}(x, i, j, ..., drop = FALSE)

\S4method{[}{dfmSparse,index,index,missing}(x, i = NULL, j = NULL, ...,
  drop = FALSE)

\S4method{[}{dfmSparse,index,index,logical}(x, i = NULL, j = NULL, ...,
  drop = FALSE)

\S4method{[}{dfmSparse,logical,missing,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{dfmSparse,index,missing,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{dfmSparse,index,missing,logical}(x, i, j, ..., drop = FALSE)

\S4method{[}{dfmSparse,missing,index,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{dfmSparse,missing,index,logical}(x, i, j, ..., drop = FALSE)

\S4method{[}{dfmSparse,missing,missing,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{dfmSparse,missing,missing,logical}(x, i, j, ..., drop = FALSE)

\S4method{+}{dfmSparse,numeric}(e1, e2)

\S4method{+}{numeric,dfmSparse}(e1, e2)

\S4method{+}{dfmDense,numeric}(e1, e2)

\S4method{+}{numeric,dfmDense}(e1, e2)

\S4method{as.matrix}{dfm}(x)

\S4method{as.data.frame}{dfm}(x)

cbind.dfm(x, y, ...)
}
\arguments{
\item{x}{the dfm object}

\item{na.rm}{if \code{TRUE}, omit missing values (including \code{NaN}) from
the calculations}

\item{dims}{ignored}

\item{...}{additional arguments not used here}

\item{i}{index for documents}

\item{j}{index for features}

\item{drop}{always set to \code{FALSE}}

\item{e1}{first quantity in "+" operation for dfm}

\item{e2}{second quantity in "+" operation for dfm}

\item{y}{a second \link{dfm} object to be joined column-wise to the first}
}
\description{
The dfm class of object is a type of \link[Matrix]{Matrix-class}
  object with additional slots, described below.  \pkg{quanteda} uses two 
  subclasses of the \code{dfm} class, depending on whether the object can be 
  represented by a sparse matrix, in which case it is a \code{dfmSparse} 
  class object, or if dense, then a \code{dfmDense} object.  See Details.
}
\details{
The \code{dfm} class is a virtual class that will contain one of two
  subclasses for containing the cell counts of document-feature matrixes: 
  \code{dfmSparse} or \code{dfmDense}.

The \code{dfmSparse} class is a sparse matrix version of
  \code{dfm-class}, inheriting \link[Matrix]{dgCMatrix-class} from the
  \pkg{Matrix} package.  It is the default object type created when feature
  counts are the object of interest, as typical text-based feature counts
  tend contain many zeroes.  As long as subsequent transformations of the dfm
  preserve cells with zero counts, the dfm should remain sparse.
  
  When the \pkg{Matrix} package implements sparse integer matrixes, we will
  switch the default object class to this object type, as integers are 4
  bytes each (compared to the current numeric double type requiring 8 bytes
  per cell.)

The \code{dfmDense} class is a sparse matrix version of \code{dfm-class}, 
inheriting \link[Matrix]{dgeMatrix-class} from the \pkg{Matrix} package.  dfm objects that
are converted through weighting or other transformations into cells without zeroes will 
be automatically converted to the dfmDense class.  This will necessarily be a much larger sized
object than one of \code{dfmSparse} class, because each cell is recorded as a numeric (double) type
requiring 8 bytes of storage.

\code{cbind(x, y, ...)} combines dfm objects by columns, returning a
  dfm object with combined features from input dfm objects.  Calls 
  \code{\link{cbind2}} defined for object classes in the \pkg{Matrix}
  package. The attributes and settings of this new dfm are not currently
  preserved.
}
\section{Slots}{

\describe{
\item{\code{settings}}{settings that govern corpus handling and subsequent downstream
operations, including the settings used to clean and tokenize the texts, 
and to create the dfm.  See \code{\link{settings}}.}

\item{\code{weighting}}{the feature weighting applied to the dfm.  Default is
\code{"frequency"}, indicating that the values in the cells of the dfm are
simple feature counts.  To change this, use the \code{\link{weight}}
method.}

\item{\code{smooth}}{a smoothing parameter, defaults to zero.  Can be changed using 
either the \code{\link{smooth}} or the \code{\link{weight}} methods.}

\item{\code{Dimnames}}{These are inherited from \link[Matrix]{Matrix-class} but are 
named \code{docs} and \code{features} respectively.}
}}
\examples{
# coercion to matrix
dfmSparse <- dfm(inaugTexts, verbose = FALSE)
str(as.matrix(dfmSparse))

# coercion to data.frame
dfmSparse <- dfm(inaugTexts, verbose = FALSE)
str(as.data.frame(dfmSparse))

# cbind() for dfm objects
dfm1 <- dfm("This is a sample text.", verbose = FALSE)
dfm2 <- dfm("one two three", verbose = FALSE)
cbind(dfm1, dfm2)
}
\seealso{
\link{dfm}
}

