% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kwic_old.R
\name{kwic_old}
\alias{kwic_old}
\title{locate keywords-in-context (older)}
\usage{
kwic_old(x, keywords, window = 5, valuetype = c("glob", "regex", "fixed"),
  case_insensitive = TRUE, ..., new = FALSE)
}
\arguments{
\item{x}{a character, \link{corpus}, or \link{tokens} object}

\item{keywords}{a keyword pattern or phrase consisting of multiple keyword 
patterns, possibly including punctuation.  If a phrase, \code{keywords} 
will be tokenized using the \code{...} options.}

\item{window}{the number of context words to be displayed around the keyword.}

\item{valuetype}{how to interpret keyword expressions: \code{"glob"} for 
"glob"-style wildcard expressions; \code{"regex"} for regular expressions;
or \code{"fixed"} for exact matching. See \link{valuetype} for details.}

\item{case_insensitive}{match without respect to case if \code{TRUE}}

\item{...}{additional arguments passed to \link{tokens}, for applicable 
object types}

\item{new}{always \code{FALSE} for this function}
}
\value{
A kwic object classed data.frame, with the document name 
  (\code{docname}), the token index position (\code{position}), the context
  before (\code{contextPre}), the keyword in its original format
  (\code{keyword}, preserving case and attached punctuation), and the context
  after (\code{contextPost}).
}
\description{
For a text or a collection of texts (in a quanteda corpus object), return a 
list of a keyword supplied by the user in its immediate context, identifying 
the source text and the word index number within the source text.  (Not the 
line number, since the text may or may not be segmented using end-of-line 
delimiters.)
}
\examples{
head(kwic_old(data_char_inaugural, "secure*", window = 3, valuetype = "glob"))
head(kwic_old(data_char_inaugural, "secur", window = 3, valuetype = "regex"))
head(kwic_old(data_char_inaugural, "security", window = 3, valuetype = "fixed"))

kwic_old(data_corpus_inaugural, "war against")
kwic_old(data_corpus_inaugural, "war against", valuetype = "regex")

}
\author{
Kenneth Benoit
}
\keyword{deprecated}
\keyword{internal}

