% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_dfm.R
\name{bootstrap_dfm}
\alias{bootstrap_dfm}
\title{bootstrap a dfm}
\usage{
bootstrap_dfm(x, n = 10, ..., verbose = quanteda_options("verbose"))
}
\arguments{
\item{x}{a character or \link{corpus} object}

\item{n}{number of resamples}

\item{...}{additional arguments passed to \code{\link{dfm}}}

\item{verbose}{if \code{TRUE} print status messages}
}
\value{
A named list of \link{dfm} objects, where the first, \code{dfm_0}, is
  the dfm from the original texts, and subsequent elements are the 
  sentence-resampled dfms.
}
\description{
Create an array of resampled dfms.
}
\details{
Function produces multiple, resampled \link{dfm} objects, based on 
  resampling sentences (wth replacement) from each document, recombining
  these into new "documents" and computing a dfm for each. Resampling of
  sentences is done strictly within document, so that every resampled
  document will contain at least some of its original tokens.
}
\examples{
# bootstrapping from the original text
txt <- c(textone = "This is a sentence.  Another sentence.  Yet another.", 
         texttwo = "Premiere phrase.  Deuxieme phrase.")
bootstrap_dfm(txt, n = 3)
         
}
\author{
Kenneth Benoit
}
\keyword{bootstrap}
\keyword{dfm}
\keyword{experimental}
