% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokens_sample.R
\name{tokens_sample}
\alias{tokens_sample}
\title{Randomly sample documents from a tokens object}
\usage{
tokens_sample(x, size = ndoc(x), replace = FALSE, prob = NULL)
}
\arguments{
\item{x}{the \link{tokens} object whose documents will be sampled}

\item{size}{a positive number, the number of documents or features to select}

\item{replace}{logical; should sampling be with replacement?}

\item{prob}{a vector of probability weights for obtaining the elements of the
vector being sampled.}
}
\value{
A \link{tokens} object with number of documents or features equal to
  \code{size}, drawn from the tokens \code{x}.
}
\description{
Sample tokenized documents randomly from a tokens object, with or without
replacement. Works just as \code{\link{sample}} works, for document-level
units (and their associated document-level variables).
}
\examples{
set.seed(10)
toks <- tokens(data_corpus_inaugural[1:10])
head(toks)
head(tokens_sample(toks))
head(tokens_sample(toks, replace = TRUE))
}
\seealso{
\link{sample}
}
\keyword{tokens}
