% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokens_select.R
\name{tokens_select}
\alias{tokens_select}
\alias{tokens_remove}
\alias{tokens_keep}
\title{Select or remove tokens from a tokens object}
\usage{
tokens_select(
  x,
  pattern,
  selection = c("keep", "remove"),
  valuetype = c("glob", "regex", "fixed"),
  case_insensitive = TRUE,
  padding = FALSE,
  window = 0,
  min_nchar = NULL,
  max_nchar = NULL,
  verbose = quanteda_options("verbose")
)

tokens_remove(x, ...)

tokens_keep(x, ...)
}
\arguments{
\item{x}{\link{tokens} object whose token elements will be removed or kept}

\item{pattern}{a character vector, list of character vectors,
\link{dictionary}, or \link{collocations} object.  See \link{pattern} for
details.}

\item{selection}{whether to \code{"keep"} or \code{"remove"} the tokens 
matching \code{pattern}}

\item{valuetype}{the type of pattern matching: \code{"glob"} for 
"glob"-style wildcard expressions; \code{"regex"} for regular expressions;
or \code{"fixed"} for exact matching. See \link{valuetype} for details.}

\item{case_insensitive}{ignore case when matching, if \code{TRUE}}

\item{padding}{if \code{TRUE}, leave an empty string where the removed tokens
previously existed.  This is useful if a positional match is needed between
the pre- and post-selected tokens, for instance if a window of adjacency 
needs to be computed.}

\item{window}{integer of length 1 or 2; the size of the window of tokens
  adjacent to \code{pattern} that will be selected. The window is symmetric
  unless a vector of two elements is supplied, in which case the first
  element will be the token length of the window before \code{pattern}, and
  the second will be the token length of the window after \code{pattern}.
  The default is \code{0}, meaning that only the pattern matched token(s) are
  selected, with no adjacent terms.

  Terms from overlapping windows are never double-counted, but simply
  returned in the pattern match. This is because \code{tokens_select} never
  redefines the document units; for this, see \code{\link{kwic}}.}

\item{min_nchar, max_nchar}{optional numerics specifying the minimum and
maximum length in characters for tokens to be removed or kept; defaults are
\code{NULL} for no limits.  These are applied after (and hence, in addition
to) any selection based on pattern matches.}

\item{verbose}{if \code{TRUE} print messages about how many tokens were 
selected or removed}

\item{...}{additional arguments passed by \code{tokens_remove} and
\code{tokens_keep} to \code{tokens_select}. Cannot include
\code{selection}.}
}
\value{
a \link{tokens} object with tokens selected or removed based on their
  match to \code{pattern}
}
\description{
These function select or discard tokens from a \link{tokens} objects.  For 
convenience, the functions \code{tokens_remove} and \code{tokens_keep} 
are defined as shortcuts for 
\code{tokens_select(x, pattern, selection = "remove")} and \code{tokens_select(x, pattern, selection = "keep")}, 
respectively.  The most common 
usage for \code{tokens_remove} will be to eliminate stop words from a text or
text-based object, while the most common use of \code{tokens_select} will be 
to select tokens with only positive pattern matches from a list of regular 
expressions, including a dictionary.
}
\examples{
## tokens_select with simple examples
toks <- tokens(c("This is a sentence.", "This is a second sentence."), 
                 remove_punct = TRUE)
tokens_select(toks, c("is", "a", "this"), selection = "keep", padding = FALSE)
tokens_select(toks, c("is", "a", "this"), selection = "keep", padding = TRUE)
tokens_select(toks, c("is", "a", "this"), selection = "remove", padding = FALSE)
tokens_select(toks, c("is", "a", "this"), selection = "remove", padding = TRUE)

# how case_insensitive works
tokens_select(toks, c("is", "a", "this"), selection = "remove", case_insensitive = TRUE)
tokens_select(toks, c("is", "a", "this"), selection = "remove", case_insensitive = FALSE)

# use window
tokens_select(toks, "second", selection = "keep", window = 1)
tokens_select(toks, "second", selection = "remove", window = 1)
tokens_remove(toks, "is", window = c(0, 1))
# tokens_remove example: remove stopwords
txt <- c(wash1 <- "Fellow citizens, I am again called upon by the voice of my country to
                   execute the functions of its Chief Magistrate.",
         wash2 <- "When the occasion proper for it shall arrive, I shall endeavor to express
                   the high sense I entertain of this distinguished honor.")
tokens_remove(tokens(txt, remove_punct = TRUE), stopwords("english"))

# token_keep example: keep two-letter words
tokens_keep(tokens(txt, remove_punct = TRUE), "??")
}
