% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object2fixed.R
\name{object2id}
\alias{object2id}
\alias{object2fixed}
\title{Match quanteda objects against token types}
\usage{
object2id(
  x,
  types,
  valuetype = c("glob", "fixed", "regex"),
  case_insensitive = TRUE,
  concatenator = "_",
  levels = 1,
  remove_unigram = FALSE,
  keep_nomatch = FALSE
)

object2fixed(
  x,
  types,
  valuetype = c("glob", "fixed", "regex"),
  case_insensitive = TRUE,
  concatenator = "_",
  levels = 1,
  remove_unigram = FALSE,
  keep_nomatch = FALSE
)
}
\arguments{
\item{x}{a list of character vectors, \link{dictionary} or collocations object}

\item{types}{token types against which patterns are matched}

\item{valuetype}{the type of pattern matching: \code{"glob"} for "glob"-style
wildcard expressions; \code{"regex"} for regular expressions; or \code{"fixed"} for
exact matching. See \link{valuetype} for details.}

\item{case_insensitive}{logical; if \code{TRUE}, ignore case when matching a
\code{pattern} or \link{dictionary} values}

\item{concatenator}{the concatenation character that join multi-word
expression in \code{types}}

\item{levels}{integers specifying the levels of entries in a hierarchical
dictionary that will be applied.  The top level is 1, and subsequent levels
describe lower nesting levels.  Values may be combined, even if these
levels are not contiguous, e.g. \code{levels = c(1:3)} will collapse the second
level into the first, but record the third level (if present) collapsed
below the first (see examples).}

\item{remove_unigram}{if \code{TRUE}, ignores single-word patterns}

\item{keep_nomatch}{keep patterns that did not match}
}
\value{
\code{object2fixed()} returns a list of character vectors of matched
types. \code{object2id()} returns a list of indices of matched types with
attributes. The "pattern" attribute records the indices of the matched patterns
in \code{x}; the "key" attribute records the keys of the matched patterns when \code{x} is
\link{dictionary}.
}
\description{
Developer function to match patterns in quanteda objects against token types.
}
\examples{
types <- c("A", "AA", "B", "BB", "B_B", "C", "C-C")

# dictionary
dict <- dictionary(list(A = c("a", "aa"), 
                        B = c("BB", "B B"),
                        C = c("C", "C-C")))
object2fixed(dict, types)
object2fixed(dict, types, remove_unigram = TRUE)

# phrase
pats <- phrase(c("a", "aa", "zz", "bb", "b b"))
object2fixed(pats, types)
object2fixed(pats, types, keep_nomatch = TRUE)
}
\seealso{
\code{\link[=pattern2id]{pattern2id()}}
}
\keyword{development}
\keyword{internal}
