% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus_chunk.R
\name{corpus_chunk}
\alias{corpus_chunk}
\title{Segment a corpus into chunks of a given size}
\usage{
corpus_chunk(
  x,
  size,
  truncate = FALSE,
  use_docvars = TRUE,
  verbose = quanteda_options("verbose")
)
}
\arguments{
\item{x}{\link{tokens} object whose token elements will be segmented into
chunks}

\item{size}{integer; the (approximate) token length of the chunks. See
Details.}

\item{truncate}{logical; if \code{TRUE}, truncate the text after \code{size}}

\item{use_docvars}{if \code{TRUE}, repeat the docvar values for each chunk;
if \code{FALSE}, drop the docvars in the chunked tokens}

\item{verbose}{if \code{TRUE} print the number of tokens and documents before and
after the function is applied. The number of tokens does not include paddings.}
}
\description{
Segment a corpus into new documents of roughly equal sized text chunks, with
the possibility of overlapping the chunks.
}
\details{
The token length is estimated using \code{stringi::stri_length(txt) / stringi::stri_count_boundaries(txt)} to avoid needing to tokenize and rejoin
the corpus from the tokens.

Note that when used for chunking texts prior to sending to large language
models (LLMs) with limited input token lengths, size should typically be set
to approximately 0.75-0.80 of the LLM's token limit.  This is because
tokenizers (such as LLaMA's SentencePiece Byte-Pair Encoding tokenizer)
require more tokens than the linguistically defined grammatically-based
tokenizer that is the \pkg{quanteda} default. Note also that because of the
use of \code{stringi::stri_count_boundaries(txt)} to approximate token length
(efficiently), the exact token length for chunking will be approximate.
}
\examples{
data_corpus_inaugural[1] |>
  corpus_chunk(size = 10)

}
\seealso{
\code{\link[=tokens_chunk]{tokens_chunk()}}
}
\keyword{corpus}
