% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{colNA}
\alias{colNA}
\title{Frequency of Missing Values by Column}
\usage{
colNA(x, prop = FALSE, ov = FALSE)
}
\arguments{
\item{x}{matrix with any typeof. If not a matrix, it will be coerced to a
matrix via \code{as.matrix}. The function allows for colnames to carry over
for non-matrix objects (e.g., data.frames).}

\item{prop}{logical vector of length 1 specifying whether the frequency of
missing values should be returned as a proportion (TRUE) or a count
(FALSE).}

\item{ov}{logical vector of length 1 specifying whether the frequency of
observed values (TRUE) should be returned rather than the frequency of
missing values (FALSE).}
}
\value{
numeric vector of length = \code{ncol(x)}, and names =
  \code{colnames(x)} providing the frequency of missing values (or observed
  values if \code{ov} = TRUE) per column. If \code{prop} = TRUE, the values
  will range from 0 to 1. If \code{prop} = FALSE, the values will range from
  1 to \code{nrow(x)}.
}
\description{
\code{rowNA} compute the frequency of missing values in a matrix by column.
This function essentially does \code{apply(X = x, MARGIN = 2, FUN = vecNA)}.
It is also used by other functions in the quest package related to missing
values (e.g., \code{\link{colMeans_if}}).
}
\examples{
colNA(as.matrix(airquality)) # count of missing values
colNA(as.matrix(airquality), prop = TRUE) # proportion of missing values
colNA(as.matrix(airquality), ov = TRUE) # count of observed values
colNA(as.data.frame(airquality), prop = TRUE, ov = TRUE) # proportion of observed values
}
\seealso{
\code{\link{is.na}}
   \code{\link{vecNA}}
   \code{\link{rowNA}}
   \code{\link{rowsNA}}
}
