% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{reverses}
\alias{reverses}
\title{Reverse Code Numeric Data}
\usage{
reverses(data, vrb.nm, mini, maxi, suffix = "_r")
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of colnames from \code{data} specifying the
variables.}

\item{mini}{numeric vector of length 1 specifying the minimum numeric value.}

\item{maxi}{numeric vector of length 1 specifying the maximum numeric value.}

\item{suffix}{character vector of length 1 specifying the string to add to
the end of the colnames in the return object.}
}
\value{
data.frame of reverse coded variables with colnames specified by
  \code{paste0(vrb.nm, suffix)}.
}
\description{
\code{reverses} reverse codes numeric data based on minimum and maximum
values. For example, say numerical values of response options can range from
1 to 4. The function will change 1 to 4, 2 to 3, 3 to 2, and 4 to 1. If there
are an odd number of response options, the middle in the sequence will be
unchanged.
}
\details{
\code{reverses} is simply a vectorized version of \code{reverse} to more
easily reverse code multiple columns of a data.frame at the same time.
}
\examples{
tmp <- !(is.element(el = names(psych::bfi) , set = c("gender","education","age")))
vrb_nm <- names(psych::bfi)[tmp]
reverses(data = psych::bfi, vrb.nm = vrb_nm, mini = 1, maxi = 6)
}
\seealso{
\code{\link{reverse}}
   \code{\link[psych]{reverse.code}}
   \code{\link{recodes}}
}
