% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psymet_functions.R
\name{composites}
\alias{composites}
\title{Composite Reliability of Multiple Scores}
\usage{
composites(
  data,
  vrb.nm.list,
  level = 0.95,
  std = FALSE,
  ci.type = "delta",
  boot.ci.type = "bca.simple",
  R = 200L,
  fit.measures = c("chisq", "df", "tli", "cfi", "rmsea", "srmr"),
  se = "standard",
  test = "standard",
  missing = "fiml",
  ...
)
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm.list}{list of character vectors containing colnames in
\code{data} specifying the multiple sets of variables/items.}

\item{level}{double vector of length 1 with a value between 0 and 1
specifying what confidence level to use.}

\item{std}{logical element of length 1 specifying if the composite
reliability should be computed for the standardized version of the
variables/items \code{data[unlist(vrb.nm.list)]}.}

\item{ci.type}{character vector of length 1 specifying which type of
confidence interval to compute. The "delta" option uses the delta method to
compute a standard error and a symmetrical confidence interval. The "boot"
option uses bootstrapping to compute an asymmetrical confidence interval as
well as a (pseudo) standard error.}

\item{boot.ci.type}{character vector of length 1 specifying which type of
bootstrapped confidence interval to compute. The options are: 1) "norm", 2)
"basic", 3) "perc", 4) "bca.simple". Only used if \code{ci.type} = "boot".
See \code{\link[lavaan]{parameterEstimates}} and its \code{boot.ci.type}
argument for details.}

\item{R}{integer vector of length 1 specifying how many bootstrapped
resamples to compute. Note, as the number of bootstrapped resamples
increases, the computation time will increase. Only used if \code{ci.type}
is "boot".}

\item{fit.measures}{character vector specifying which model fit indices to
include in the return object. The default option includes the chi-square
test statistic ("chisq"), degrees of freedom ("df"), tucker-lewis index
("tli"), comparative fit index ("cfi"), root mean square error of
approximation ("rmsea"), and standardized root mean residual ("srmr"). If
NULL, then no model fit indices are included in the return object. See
\code{\link[lavaan]{fitMeasures}} for details.}

\item{se}{character vector of length 1 specifying which type of standard
errors to compute. If ci.type = "boot", then the input value is ignored and
implicitly set to "bootstrap". See \code{\link[lavaan]{lavOptions}} and its
\code{se} argument for details.}

\item{test}{character vector of length 1 specifying which type of test
statistic to compute. If ci.type = "boot", then the input value is ignored
and implicitly set to "bootstrap". See \code{\link[lavaan]{lavOptions}} and
its \code{test} argument for details.}

\item{missing}{character vector of length 1 specifying how to handle missing
data. The default is "fiml" for full information maximum likelihood. See
\code{\link[lavaan]{lavOptions}} and its \code{missing} argument for
details.}

\item{...}{other arguments passed to \code{\link[lavaan]{cfa}}. Use at your
own peril as some argument values could cause the function to break.}
}
\value{
data.frame containing the composite reliability of each set of variables/items.

\describe{
   \item{est}{estimate of the reliability coefficient}
   \item{se}{standard error of the reliability coefficient}
   \item{lwr}{lower bound of the confidence interval of the reliability coefficient}
   \item{upr}{upper bound of the confidence interval of the reliability coefficient}
   \item{average_l}{average standardized factor loading from the factor model}
   \item{nvrb}{number of variables/items}
   \item{???}{any model fit indices requested by the \code{fit.measures} argument}
}
}
\description{
\code{composites} computes the composite reliability coefficient (sometimes
referred to as omega) for multiple sets of variables/items. The composite
reliability computed in \code{composites} assumes a undimensional factor
model for each set of variables/items with no error covariances. In addition
to the coefficients themselves, their standard errors and confidence
intervals are returned, the average standardized factor loading from the
factor models and number of variables/items in each set, and (optional) model
fit indices of the factor models. Note, any reverse coded items need to be
recoded ahead of time so that all items are keyed in the same direction for
each set of variables/items.
}
\details{
The factor models are estimated using the R package \code{lavaan}. The
reliability coefficients are calculated based on the square of the sum of the
factor loadings divided by the sum of the square of the sum of the factors
loadings and the sum of the error variances (Raykov, 2001).

\code{composites} is only able to use the "ML" estimator at the moment and
cannot model items as categorical/ordinal. However, different versions of
standard errors and test statistics are possible. For example, the "MLM"
estimator can be specified by \code{se} = "robust.sem" and \code{test} =
"satorra.bentler"; the "MLR" estimator can be specified by \code{se} =
"robust.huber.white" and \code{test} = "yuan.bentler.mplus". See
\code{\link[lavaan]{lavOptions}} and scroll down to Estimation options for
details.
}
\examples{

dat0 <- psych::bfi[1:250, ]
dat1 <- str2str::pick(x = dat0, val = c("A1","C4","C5","E1","E2","O2","O5",
   "gender","education","age"), not = TRUE, nm = TRUE)
vrb_nm_list <- lapply(X = str2str::sn(c("E","N","C","A","O")), FUN = function(nm) {
   str2str::pick(x = names(dat1), val = nm, pat = TRUE)})
composites(data = dat1, vrb.nm.list = vrb_nm_list)
\dontrun{
start_time <- Sys.time()
composites(data = dat1, vrb.nm.list = vrb_nm_list, ci.type = "boot",
   R = 5000L) # the function is not optimized for speed at the moment
   # since it will bootstrap separately for each set of variables/items
end_time <- Sys.time()
print(end_time - start_time) # takes 10 minutes on my laptop
}
composites(data = attitude,
   vrb.nm.list = list(names(attitude))) # also works with only one set of variables/items

}
\references{
Raykov, T. (2001). Estimation of congeneric scale reliability using covariance
structure analysis with nonlinear constraints. British Journal of Mathematical
and Statistical Psychology, 54(2), 315–323.
}
\seealso{
\code{\link{composite}}
   \code{\link{cronbachs}}
}
