% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inc.R
\name{inc}
\alias{inc}
\title{Increment vector by value}
\usage{
inc(., add = 1)
}
\arguments{
\item{.}{vector of number(s)}

\item{add}{number to add}
}
\value{
a vector incremented by a number
}
\description{
Increment the content of a vector and re-save as the vector
}
\details{
This function is very useful when writing complex codes involving loops.
Apart from the for loop, this can be useful to quickly increment a variable located outside the loop
by simply incrementing the variable by 1 or other numbers. Check in the example section for a specific use.
Nonetheless, one may also choose to use this function in any other instance, as it's simple purpose is
to increase the value of a variable by a number and then re-save the new value to that variable.
}
\examples{
num1 <- sample(330:400,10)
num1#before increment

# increment num1 by 1
inc(num1)
num1 #after increment

# increment num1 by 5
num1 #before increment
inc(num1, add= 10)
num1 #after increment

#when used in loops

#add and compare directly
rnum = 10
inc(rnum) == 11 #returns TRUE
rnum #the variable was also updated

#use in a repeat loop
xnum = 1
repeat{ #repeat until xnum is 15
message(xnum)
if(inc(xnum) == 15) break
}
}
