% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/co2_intensity_scenario_demo.R
\docType{data}
\name{co2_intensity_scenario_demo}
\alias{co2_intensity_scenario_demo}
\title{A prepared co2 intensity climate scenario dataset for demonstration}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 22 rows and 7 columns.
}
\usage{
co2_intensity_scenario_demo
}
\description{
Fake co2 intensity climate scenario dataset, prepared for the software
PACTA (Paris Agreement Capital Transition Assessment). It imitates
climate scenario data (e.g. from the International Energy Agency (IEA))
including the change through time in production across industrial sectors
(calculated by \href{https://2degrees-investing.org/}{2DII}).

Demo datasets are synthetic because most financial data is strictly private;
they help to demonstrate and test the implementation in R of 'PACTA'
(\url{https://2degrees-investing.org/resource/pacta/}).
}
\section{Definitions}{

\itemize{
\item \code{emission_factor} (double): The target sector level emissions factor that the scenario prescribes.
\item \code{emission_factor_unit} (character): The units that the emissions factor is measured in.
\item \code{region} (character): The region to which the pathway is relevant.
\item \code{scenario} (character): The name of the scenario.
\item \code{scenario_source} (character): The source publication from which the scenario was taken.
\item \code{sector} (character): The sector to which the scenario prescribes a pathway.
\item \code{year} (integer): The year at which the pathway value is prescribed.
}
}

\examples{
head(co2_intensity_scenario_demo)
}
\seealso{
\link{data_dictionary}

Other demo datasets: 
\code{\link{ald_demo}},
\code{\link{loanbook_demo}},
\code{\link{overwrite_demo}},
\code{\link{region_isos_demo}},
\code{\link{scenario_demo_2020}}
}
\concept{demo datasets}
\keyword{datasets}
