% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification_bridge.R
\docType{data}
\name{nace_classification}
\alias{nace_classification}
\title{Dataset to bridge (translate) common sector-classification codes}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 996 rows and 5 columns.
}
\usage{
nace_classification
}
\description{
This dataset serves as a translation key between common sector-classification
systems and sectors relevant to the 'PACTA' tool
(\url{https://2degrees-investing.org/resource/pacta/}).
}
\section{Definitions}{

\itemize{
\item \code{borderline} (logical): Flag indicating if 2dii sector and classification code are a borderline match. The value TRUE indicates that the match is uncertain between the 2dii sector and the classification. The value FALSE indicates that the match is certainly perfect or the classification is certainly out of 2dii's scope..
\item \code{code} (character): Formatted NACE code with periods removed.
\item \code{code_level} (double): Level of granularity of NACE code.
\item \code{original_code} (character): Original NACE code.
\item \code{sector} (character): Associated 2dii sector.
}
}

\section{Details}{

Classification datasets help to standardize sector classification codes from
the wild to a relevant subset including 'power', 'oil and gas', 'coal',
'automotive', 'aviation', 'concrete', 'steel', and 'shipping'.
}

\examples{
head(nace_classification)
}
\seealso{
\link{data_dictionary}.

Other datasets for bridging sector classification codes: 
\code{\link{cnb_classification}},
\code{\link{gics_classification}},
\code{\link{isic_classification}},
\code{\link{naics_classification}},
\code{\link{psic_classification}},
\code{\link{sector_classifications}},
\code{\link{sic_classification}}
}
\concept{datasets for bridging sector classification codes}
\keyword{datasets}
