/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.util.ArrayList;
import java.util.List;
import org.jpmml.converter.Feature;
import org.jpmml.rexp.FormulaContext;
import org.jpmml.rexp.LMConverter;
import org.jpmml.rexp.RDoubleVector;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.RExpEncoder;
import org.jpmml.rexp.RGenericVector;
import org.jpmml.rexp.RStringVector;
import org.jpmml.rexp.RVector;

public abstract class RMSConverter
extends LMConverter {
    public static final String INTERCEPT = "Intercept";

    public RMSConverter(RGenericVector rms) {
        super(rms);
    }

    @Override
    public void encodeSchema(RExpEncoder encoder) {
        RGenericVector rms = (RGenericVector)this.getObject();
        RExp terms = (RExp)rms.getElement("terms");
        RGenericVector design = rms.getGenericElement("Design");
        final RGenericVector parms = design.getGenericElement("parms", false);
        FormulaContext context = new FormulaContext(){

            @Override
            public List<String> getCategories(String variable) {
                if (parms != null && parms.hasElement(variable)) {
                    RStringVector levels = parms.getStringElement(variable);
                    return levels.getValues();
                }
                return null;
            }

            @Override
            public RVector<?> getData(String variable) {
                return null;
            }
        };
        this.encodeSchema(terms, context, encoder);
    }

    @Override
    public String getInterceptName() {
        return INTERCEPT;
    }

    @Override
    public List<String> getCoefficientNames() {
        RGenericVector rms = (RGenericVector)this.getObject();
        RGenericVector design = rms.getGenericElement("Design");
        RStringVector mmcolnames = design.getStringElement("mmcolnames");
        ArrayList<String> result = new ArrayList<String>();
        result.add(INTERCEPT);
        result.addAll(mmcolnames.getDequotedValues());
        return result;
    }

    @Override
    public List<Double> getFeatureCoefficients(List<? extends Feature> features, RDoubleVector coefficients) {
        List<Double> values = coefficients.getValues();
        return values.subList(1, values.size());
    }
}

