/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.Value;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.PMMLUtil;

public class ValueDecorator
implements Decorator {
    private Value.Property property = null;
    private List<Object> values = new ArrayList<Object>();

    protected ValueDecorator(Value.Property property) {
        this.setProperty(property);
    }

    @Override
    public void decorate(DataField dataField, MiningField miningField) {
        Value.Property property = this.getProperty();
        List<Object> values = this.getValues();
        if (values.size() > 0) {
            PMMLUtil.addValues(dataField, values, property);
        }
    }

    public Value.Property getProperty() {
        return this.property;
    }

    private ValueDecorator setProperty(Value.Property property) {
        this.property = property;
        return this;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public ValueDecorator addValues(Object ... values) {
        this.getValues().addAll(Arrays.asList(values));
        return this;
    }
}

