% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgboost.R
\name{genDMatrix}
\alias{genDMatrix}
\title{Generates an XGBoost "DMatrix" object based on label and feature data.}
\usage{
genDMatrix(df_y, df_X, file = tempfile(pattern = "DMatrix", fileext =
  ".libsvm"))
}
\arguments{
\item{df_y}{A vector with dependent variable values.}

\item{df_X}{A "data.frame" object with independent variable values.}

\item{file}{A filesystem path for storing the temporary LibSVM data format file.}
}
\value{
An "xgb.DMatrix" object.
}
\description{
Generates an XGBoost "DMatrix" object based on label and feature data.
}
\examples{
data(iris)
iris.DMatrix = genDMatrix(as.integer(iris[, 5]) - 1, iris[, 1:4])
}
