/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter.visitors;

import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasDerivedFields;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.mining.MiningModel;
import org.jpmml.converter.DerivedOutputField;
import org.jpmml.converter.visitors.DeepFieldResolver;
import org.jpmml.converter.visitors.DeepFieldResolverUtil;
import org.jpmml.converter.visitors.FieldDependencyResolver;
import org.jpmml.model.visitors.AbstractVisitor;
import org.jpmml.model.visitors.FieldResolver;

public class DerivedFieldRelocator
extends DeepFieldResolver {
    private Map<DerivedField, Set<Model>> derivedFieldModels = new IdentityHashMap<DerivedField, Set<Model>>();

    @Override
    public void applyTo(Visitable visitable) {
        this.derivedFieldModels.clear();
        super.applyTo(visitable);
    }

    public PMMLObject popParent() {
        PMMLObject parent = super.popParent();
        if (parent instanceof Model) {
            this.processModel((Model)parent);
        } else if (parent instanceof PMML) {
            this.processPMML((PMML)parent);
        }
        return parent;
    }

    private void processModel(Model model) {
        LinkedHashSet<Model> parentModels = new LinkedHashSet<Model>();
        parentModels.add(model);
        Deque parents = this.getParents();
        for (PMMLObject parent : parents) {
            if (!(parent instanceof Model)) continue;
            Model parentModel = (Model)parent;
            parentModels.add(parentModel);
        }
        Set<DerivedField> activeDerivedFields = this.getActiveDerivedFields(model);
        for (DerivedField activeDerivedField : activeDerivedFields) {
            Set<Model> models = this.derivedFieldModels.get(activeDerivedField);
            if (models == null) {
                models = new LinkedHashSet<Model>(parentModels);
                this.derivedFieldModels.put(activeDerivedField, models);
                continue;
            }
            models.retainAll(parentModels);
        }
    }

    private void processPMML(PMML pmml) {
        final IdentityHashMap<DerivedField, Model> derivedFieldScopes = new IdentityHashMap<DerivedField, Model>();
        Set<Map.Entry<DerivedField, Set<Model>>> entries = this.derivedFieldModels.entrySet();
        for (Map.Entry entry : entries) {
            DerivedField derivedField = (DerivedField)entry.getKey();
            Set models = (Set)entry.getValue();
            if (derivedField instanceof DerivedOutputField) {
                DerivedOutputField derivedOutputField = (DerivedOutputField)derivedField;
                continue;
            }
            if (models.size() <= 0) continue;
            Model model = (Model)models.iterator().next();
            derivedFieldScopes.put(derivedField, model);
        }
        final IdentityHashMap orderMap = new IdentityHashMap();
        AbstractVisitor abstractVisitor = new AbstractVisitor(){

            public VisitorAction visit(DerivedField derivedField) {
                Integer index = orderMap.size();
                orderMap.put(derivedField, index);
                return super.visit(derivedField);
            }

            public VisitorAction visit(LocalTransformations localTransformations) {
                Model model = (Model)this.getParent();
                if (localTransformations.hasDerivedFields()) {
                    List derivedFields = localTransformations.getDerivedFields();
                    for (DerivedField derivedField : derivedFields) {
                        Model scope = (Model)derivedFieldScopes.get(derivedField);
                        if (scope == null || !Objects.equals(scope, model)) continue;
                        derivedFieldScopes.remove(derivedField);
                    }
                }
                return super.visit(localTransformations);
            }
        };
        AbstractVisitor relocator = new AbstractVisitor(){

            public VisitorAction visit(LocalTransformations localTransformations) {
                Model model = (Model)this.getParent();
                this.processDerivedFields((HasDerivedFields<?>)localTransformations, model);
                return super.visit(localTransformations);
            }

            public VisitorAction visit(Model model) {
                LocalTransformations localTransformations = model.getLocalTransformations();
                Set entries = derivedFieldScopes.entrySet();
                for (Map.Entry entry : entries) {
                    DerivedField derivedField = (DerivedField)entry.getKey();
                    Model scope = (Model)entry.getValue();
                    if (!Objects.equals(scope, model)) continue;
                    if (localTransformations == null) {
                        localTransformations = new LocalTransformations();
                        model.setLocalTransformations(localTransformations);
                    }
                    localTransformations.addDerivedFields(new DerivedField[]{derivedField});
                }
                return super.visit(model);
            }

            public VisitorAction visit(TransformationDictionary transformationDictionary) {
                this.processDerivedFields((HasDerivedFields<?>)transformationDictionary, null);
                return super.visit(transformationDictionary);
            }

            private void processDerivedFields(HasDerivedFields<?> hasDerivedFields, Model parent) {
                if (hasDerivedFields.hasDerivedFields()) {
                    List derivedFields = hasDerivedFields.getDerivedFields();
                    Iterator it = derivedFields.iterator();
                    while (it.hasNext()) {
                        DerivedField derivedField = (DerivedField)it.next();
                        Model scope = (Model)derivedFieldScopes.get(derivedField);
                        if (scope == null || parent != null && Objects.equals(scope, parent)) continue;
                        it.remove();
                    }
                }
            }
        };
        AbstractVisitor sorter = new AbstractVisitor(){
            private Comparator<DerivedField> comparator = new Comparator<DerivedField>(){

                @Override
                public int compare(DerivedField left, DerivedField right) {
                    Integer leftIndex = (Integer)orderMap.get(left);
                    Integer rightIndex = (Integer)orderMap.get(right);
                    return leftIndex.compareTo(rightIndex);
                }
            };

            public VisitorAction visit(LocalTransformations localTransformations) {
                this.sort((HasDerivedFields<?>)localTransformations);
                return super.visit(localTransformations);
            }

            public VisitorAction visit(TransformationDictionary transformationDictionary) {
                this.sort((HasDerivedFields<?>)transformationDictionary);
                return super.visit(transformationDictionary);
            }

            private void sort(HasDerivedFields<?> hasDerivedFields) {
                if (hasDerivedFields.hasDerivedFields()) {
                    List derivedFields = hasDerivedFields.getDerivedFields();
                    derivedFields.sort(this.comparator);
                }
            }
        };
        abstractVisitor.applyTo((Visitable)pmml);
        relocator.applyTo((Visitable)pmml);
        sorter.applyTo((Visitable)pmml);
    }

    private Set<DerivedField> getActiveDerivedFields(Model model) {
        FieldDependencyResolver fieldDependencyResolver = this.getFieldDependencyResolver();
        Set<Field<?>> activeFields = model instanceof MiningModel ? DeepFieldResolverUtil.getActiveFields((FieldResolver)this, (MiningModel)model) : DeepFieldResolverUtil.getActiveFields((FieldResolver)this, model);
        HashSet<DerivedField> activeDerivedFields = new HashSet<DerivedField>();
        activeDerivedFields.addAll(fieldDependencyResolver.expand(activeFields, fieldDependencyResolver.getLocalDerivedFields()));
        activeDerivedFields.addAll(fieldDependencyResolver.expand(activeFields, fieldDependencyResolver.getGlobalDerivedFields()));
        return activeDerivedFields;
    }
}

