/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasDiscreteDomain;
import org.dmg.pmml.Header;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMML;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.Version;
import org.jpmml.converter.DerivedOutputField;
import org.jpmml.converter.PMMLUtil;

public class PMMLEncoder {
    private Map<String, DataField> dataFields = new LinkedHashMap<String, DataField>();
    private Map<String, DerivedField> derivedFields = new LinkedHashMap<String, DerivedField>();
    private Map<String, DefineFunction> defineFunctions = new LinkedHashMap<String, DefineFunction>();
    public static final Version VERSION = Version.PMML_4_4;

    public PMML encodePMML() {
        if (!Collections.disjoint(this.dataFields.keySet(), this.derivedFields.keySet())) {
            throw new IllegalStateException();
        }
        ArrayList<DataField> dataFields = new ArrayList<DataField>(this.dataFields.values());
        DataDictionary dataDictionary = new DataDictionary();
        if (!dataFields.isEmpty()) {
            dataDictionary.getDataFields().addAll(dataFields);
        }
        ArrayList<DerivedField> derivedFields = new ArrayList<DerivedField>(this.derivedFields.values());
        ArrayList<DefineFunction> defineFunctions = new ArrayList<DefineFunction>(this.defineFunctions.values());
        TransformationDictionary transformationDictionary = null;
        if (!derivedFields.isEmpty() || !defineFunctions.isEmpty()) {
            transformationDictionary = new TransformationDictionary();
            if (!derivedFields.isEmpty()) {
                transformationDictionary.getDerivedFields().addAll(derivedFields);
            }
            if (!defineFunctions.isEmpty()) {
                transformationDictionary.getDefineFunctions().addAll(defineFunctions);
            }
        }
        Header header = this.encodeHeader();
        PMML pmml = new PMML(VERSION.getVersion(), header, dataDictionary).setTransformationDictionary(transformationDictionary);
        return pmml;
    }

    public Header encodeHeader() {
        return PMMLUtil.createHeader(this);
    }

    public DataField getDataField(String name) {
        return this.dataFields.get(name);
    }

    public void addDataField(DataField dataField) {
        String name = this.checkName((Field<?>)dataField);
        this.dataFields.put(name, dataField);
    }

    public DataField createDataField(String name, OpType opType, DataType dataType) {
        return this.createDataField(name, opType, dataType, null);
    }

    public DataField createDataField(String name, OpType opType, DataType dataType, List<?> values) {
        DataField dataField = new DataField(name, opType, dataType);
        if (values != null && !values.isEmpty()) {
            PMMLUtil.addValues(dataField, values);
        }
        this.addDataField(dataField);
        return dataField;
    }

    public DataField removeDataField(String name) {
        DataField dataField = this.dataFields.remove(name);
        if (dataField == null) {
            throw new IllegalArgumentException("Field " + name + " is undefined");
        }
        return dataField;
    }

    public DerivedField ensureDerivedField(String name, OpType opType, DataType dataType, Supplier<? extends Expression> expressionSupplier) {
        DerivedField derivedField = this.getDerivedField(name);
        if (derivedField == null) {
            Expression expression = expressionSupplier.get();
            derivedField = this.createDerivedField(name, opType, dataType, expression);
        }
        return derivedField;
    }

    public DerivedField getDerivedField(String name) {
        return this.derivedFields.get(name);
    }

    public void addDerivedField(DerivedField derivedField) {
        String name = this.checkName((Field<?>)derivedField);
        this.derivedFields.put(name, derivedField);
    }

    public DerivedField createDerivedField(String name, OpType opType, DataType dataType, Expression expression) {
        DerivedField derivedField = new DerivedField(name, opType, dataType, expression);
        this.addDerivedField(derivedField);
        return derivedField;
    }

    public DerivedOutputField createDerivedField(Model model, OutputField outputField, boolean required) {
        DerivedOutputField derivedField = new DerivedOutputField(model, outputField, required);
        this.addDerivedField(derivedField);
        return derivedField;
    }

    public DerivedField removeDerivedField(String name) {
        DerivedField derivedField = this.derivedFields.remove(name);
        if (derivedField == null) {
            throw new IllegalArgumentException("Field " + name + " is undefined");
        }
        return derivedField;
    }

    public Field<?> getField(String name) {
        DataField dataField = this.getDataField(name);
        DerivedField derivedField = this.getDerivedField(name);
        if (dataField != null && derivedField != null) {
            throw new IllegalStateException();
        }
        if (dataField != null && derivedField == null) {
            return dataField;
        }
        if (dataField == null && derivedField != null) {
            return derivedField;
        }
        throw new IllegalArgumentException("Field " + name + " is undefined");
    }

    public Field<?> toContinuous(String name) {
        Field<?> field = this.getField(name);
        DataType dataType = field.requireDataType();
        switch (dataType) {
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + name + " has data type " + dataType);
            }
        }
        field.setOpType(OpType.CONTINUOUS);
        return field;
    }

    public Field<?> toCategorical(String name, List<?> values) {
        return this.toDiscrete(name, OpType.CATEGORICAL, values);
    }

    public Field<?> toOrdinal(String name, List<?> values) {
        return this.toDiscrete(name, OpType.ORDINAL, values);
    }

    public DefineFunction getDefineFunction(String name) {
        return this.defineFunctions.get(name);
    }

    public void addDefineFunction(DefineFunction defineFunction) {
        String name = defineFunction.requireName();
        if (this.defineFunctions.containsKey(name)) {
            throw new IllegalArgumentException(name);
        }
        this.defineFunctions.put(name, defineFunction);
    }

    public Map<String, DataField> getDataFields() {
        return this.dataFields;
    }

    public Map<String, DerivedField> getDerivedFields() {
        return this.derivedFields;
    }

    public Map<String, DefineFunction> getDefineFunctions() {
        return this.defineFunctions;
    }

    private Field<?> toDiscrete(String name, OpType opType, List<?> values) {
        Field<?> field = this.getField(name);
        if (field instanceof HasDiscreteDomain && values != null && !values.isEmpty()) {
            List<?> existingValues = PMMLUtil.getValues((Field)((HasDiscreteDomain)field));
            if (existingValues != null && !existingValues.isEmpty()) {
                if (!existingValues.equals(values)) {
                    throw new IllegalArgumentException("Expected " + existingValues + "as valid values, got " + values);
                }
            } else {
                PMMLUtil.addValues((Field)((HasDiscreteDomain)field), values);
            }
        }
        field.setOpType(opType);
        return field;
    }

    private String checkName(Field<?> field) {
        String name = field.requireName();
        if (this.dataFields.containsKey(name) || this.derivedFields.containsKey(name)) {
            throw new IllegalArgumentException("Field " + name + " is already defined");
        }
        return name;
    }
}

