% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_attributes.R
\name{rtf_title}
\alias{rtf_title}
\title{Add title attributes to the table}
\usage{
rtf_title(
  tbl,
  title = NULL,
  subtitle = NULL,
  font = 1,
  format = NULL,
  font_size = 12,
  color = NULL,
  background_color = NULL,
  justification = "c",
  indent_first = 0,
  indent_left = 0,
  indent_right = 0,
  space = 1,
  space_before = 180,
  space_after = 180,
  new_page = FALSE,
  hyphenation = TRUE
)
}
\arguments{
\item{tbl}{a data frame}

\item{title}{title string}

\item{subtitle}{subtitle string}

\item{font}{text font type}

\item{format}{text format}

\item{font_size}{text font size}

\item{color}{text color}

\item{background_color}{text background color}

\item{justification}{justification for text}

\item{indent_first}{first indent}

\item{indent_left}{left indent}

\item{indent_right}{right indent}

\item{space}{paragraph space}

\item{space_before}{line space before text}

\item{space_after}{line space after text}

\item{new_page}{boolean value to indicate whether to start a new page}

\item{hyphenation}{boolean value to indicate whether to use hyphenation}
}
\value{
the same data frame \code{tbl} with additional attributes for table title
}
\description{
add title, subtitle, and other attributes to the object
}
\examples{
library(dplyr) # required to run examples
data(tbl_1)
tbl_1 \%>\% rtf_title(title = "ANCOVA of Change from Baseline at Week 8") \%>\%
  attr("rtf_heading")

}
