% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/footnote_source_space.R
\name{footnote_source_space}
\alias{footnote_source_space}
\title{Derive Space Adjustment}
\usage{
footnote_source_space(tbl, text_indent_reference = "table")
}
\arguments{
\item{tbl}{A data frame.}

\item{text_indent_reference}{The reference start point of text indent. Accept \code{table} or \code{page_margin}}
}
\value{
a value indicating the amount of space adjustment
}
\description{
Derive Space Adjustment
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Collect page width, page margins and table width attributes from `tbl` object.
   \item Convert the attributes from inch to twip using 'inch_to_twip()'.
   \item Derive the adjusted space by discounting page margins and table width from page width, then divided by 2.
   \item Set the adjusted space to 0 if previous derivation returns to negative value.
 }
 }
\if{html}{The contents of this section are shown in PDF user manual only.}
}

