% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connectButton.R
\name{connectButton}
\alias{connectButton}
\title{Add Connect with us buttons}
\usage{
connectButton(
  link,
  image = NULL,
  text = NULL,
  position = c("left", "right", "inline"),
  display.inline = TRUE,
  link.out = TRUE,
  visit.us = FALSE,
  facebook = FALSE,
  linkedin = FALSE,
  twitter = FALSE,
  tumblr = FALSE,
  pinterest = FALSE,
  whatsapp = FALSE,
  reddit = FALSE,
  instagram = FALSE,
  blogger = FALSE,
  weibo = FALSE,
  tiktok = FALSE,
  vk = FALSE,
  telegram = FALSE,
  youtube = FALSE
)
}
\arguments{
\item{link}{the direct link to connect to}

\item{image}{image link only for pinterest}

\item{text}{text link for twitter}

\item{position}{position of buttons e.g "left","right","bottom","inline"}

\item{display.inline}{TRUE or FALSE if the button should be inline}

\item{link.out}{visit custom link}

\item{visit.us}{visit custom link}

\item{facebook}{link to an account on Facebook}

\item{linkedin}{link to an account on Linkedin}

\item{twitter}{link to an account on Twitter}

\item{tumblr}{link to an account on Tumblr}

\item{pinterest}{link to an account on Pinterest}

\item{whatsapp}{link to an account on Whatsapp}

\item{reddit}{link to an account on Reddit}

\item{instagram}{link to an account on Instagram}

\item{blogger}{link to an account on blogger}

\item{weibo}{link to an account on weibo}

\item{tiktok}{link to an account on tiktok}

\item{vk}{link to an account on VK or VKontakte}

\item{telegram}{link to an account on Telegram}

\item{youtube}{link to an account on Youtube}
}
\value{
Connect with me/us button via social links
}
\description{
Buttons for others to connect socially to you
}
\section{Examples for r2social}{

More examples and demo pages are located at this link -
\url{https://rpkg.net/package/r2social}.
}

\examples{
connectButton(
link = "//rpkg.net",
visit.us = TRUE,
position = "left")
connectButton(
link = "//www.linkedin.com/in/oobianom",
linkedin = TRUE,
position = "right")
connectButton(
link = "//twitter.com/R2Rpkg",
twitter = TRUE, position = "inline")

}
