% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_3PG.R
\name{run_3PG}
\alias{run_3PG}
\title{Runs a 3-PG model simulation}
\usage{
run_3PG(site, species, climate, thinning = NULL, parameters = NULL,
  size_dist = NULL, settings = NULL, check_input = TRUE, df_out = TRUE)
}
\arguments{
\item{site}{table as described in \code{\link{prepare_input}} containing the information about site conditions.}

\item{species}{table as described in \code{\link{prepare_input}} containing the information about species level data. Each row corresponds to one species/cohort.}

\item{climate}{table as described in \code{\link{prepare_input}} containing the information about monthly values for climatic data. See also \code{\link{prepare_climate}}}

\item{thinning}{table as described in \code{\link{prepare_input}} containing the information about thinnings. See also \code{\link{prepare_thinning}}}

\item{parameters}{table as described in \code{\link{prepare_input}} containing the information about parameters to be modified. See also \code{\link{prepare_parameters}}}

\item{size_dist}{table as described in \code{\link{prepare_input}} containing the information about size distributions. See also \code{\link{prepare_sizeDist}}}

\item{settings}{a list as described in \code{\link{prepare_input}} with settings for the model.}

\item{check_input}{\code{logical} if the input shall be checked for consistency. It will call \code{\link{prepare_input}} function.}

\item{df_out}{\code{logical} if the output shall be long data.frame (TRUE) the 4-dimensional array (FALSE).}
}
\value{
either a 4-dimentional array or a data.frame, depending on the parameter \code{df_out}.
}
\description{
Runs the 3-PGpjs (monospecific, evenaged and evergreen forests) or 3-PGmix (deciduous, uneven-aged or mixed-species forests) model. For more details on parameters and structure of input visit \code{\link{prepare_input}}.
}
\details{
`r3PG` provides an implementation of the Physiological Processes Predicting Growth \href{https://3pg.forestry.ubc.ca}{3-PG} model, which simulates forest growth and productivity. The `r3PG` serves as a flexible and easy-to-use interface for the `3-PGpjs` (monospecific, evenaged and evergreen forests) and the `3-PGmix` (deciduous, uneven-aged or mixed-species forests) model written in `Fortran`. The package, allows for fast and easy interaction with the model, and `Fortran` re-implementation facilitates computationally intensive sensitivity analysis and calibration. The user can flexibly switch between various options and submodules, to use the original `3-PGpjs` model version for monospecific, even-aged and evergreen forests and the `3-PGmix` model, which can also simulate multi-cohort stands (e.g. mixtures, uneven-aged) that contain deciduous species.

This implementation of 3-PG includes several major variants / modifications of the model in particular the ability to switch between 3-PGpjs (the more classic model version for monospecific stands) vs. 3-PGmix (a version for mixed stands), as well as options for bias corrections and \eqn{\delta^13 C} calculations (see parameters).
}
\note{
The \code{run_3PG} also checks the quality of input data. When names, or structures are not consistent with requirements it will return an error. Turn this off to optimize for speed.
}
\examples{
out <- run_3PG(
  site = d_site,
  species = d_species,
  climate = d_climate,
  thinning = d_thinning,
  parameters = d_parameters,
  size_dist = d_sizeDist,
  settings = list(light_model = 2, transp_model = 2, phys_model = 2,
                  correct_bias = 1, calculate_d13c = 0),
  check_input = TRUE, df_out = TRUE) # note that default is TRUE

str(out) # List output format
}
\references{
Forrester, D. I., 2020. 3-PG User Manual. Swiss Federal Institute for Forest, Snow and Landscape Research WSL, Birmensdorf, Switzerland. 70 p. Available at the following web site: \url{http://sites.google.com/site/davidforresterssite/home/projects/3PGmix/3pgmixdownload}

Forrester, D. I., & Tang, X. (2016). Analysing the spatial and temporal dynamics of species interactions in mixed-species forests and the effects of stand density using the 3-PG model. Ecological Modelling, 319, 233–254. \doi{10.1016/j.ecolmodel.2015.07.010}

Landsberg, J. J., & Waring, R. H., 1997. A generalised model of forest productivity using simplified concepts of radiation-use efficiency, carbon balance and partitioning. Forest Ecology and Management, 95(3), 209–228. \doi{10.1016/S0378-1127(97)00026-1}

Sands, P. J., 2010. 3PGpjs user manual. Available at the following web site: \url{http://3pg.sites.olt.ubc.ca/files/2014/04/3PGpjs_UserManual.pdf}
}
\seealso{
\code{\link{prepare_input}}, \code{\link{prepare_parameters}}, \code{\link{prepare_sizeDist}}, \code{\link{prepare_thinning}}, \code{\link{prepare_climate}}
}
