% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove.R
\name{m_remove_all_shapes}
\alias{m_remove_all_shapes}
\title{Remove all shape objects from viewer}
\usage{
m_remove_all_shapes(id)
}
\arguments{
\item{id}{R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})}
}
\value{
id R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})
}
\description{
Remove all shape objects from viewer
}
\examples{
library(r3dmol)

mol <- r3dmol() \%>\%
  m_add_model(data = pdb_6zsl, format = "pdb") \%>\%
  m_add_sphere(spec = list(
    center = list(x = 0, y = 0, z = 0),
    radius = 10.0,
    color = "red"
  ))

# Render model with shape
mol

# Remove shape
mol \%>\%
  m_remove_all_shapes()
}
