% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3JSsetup.R
\name{mtext3js}
\alias{mtext3js}
\title{Add text to the margin of an r3js plot}
\usage{
mtext3js(data3js, text, side, line = 0, at = 0.5, cornerside = "f", ...)
}
\arguments{
\item{data3js}{The data3js object}

\item{text}{The margin text}

\item{side}{The axis side, either "x", "y" or "z"}

\item{line}{The number of lines away from the plot edge}

\item{at}{Position along the plot edge, defaults to 0.5 (middle)}

\item{cornerside}{See \code{material3js()}}

\item{...}{Other arguments to pass to \code{material3js()}}
}
\value{
Returns an updated data3js object
}
\description{
This is used for example to add axis labels but can also
be used for other purposes.
}
\examples{
# Create a blank plot
p <- plot3js.new()
p <- box3js(p)

# Add some margin text
p <- mtext3js(p, "0.5m", side = "x")
p <- mtext3js(p, "0.25m", side = "x", at = 0.25, line = 1)
p <- mtext3js(p, "1m", side = "y", at = 1, line = 2)
r3js(p)

}
\seealso{
Other plot components: 
\code{\link{arrows3js}()},
\code{\link{axis3js}()},
\code{\link{box3js}()},
\code{\link{grid3js}()},
\code{\link{legend3js}()},
\code{\link{light3js}()},
\code{\link{lines3js}()},
\code{\link{points3js}()},
\code{\link{segments3js}()},
\code{\link{shape3js}()},
\code{\link{sphere3js}()},
\code{\link{surface3js}()},
\code{\link{text3js}()},
\code{\link{triangle3js}()}
}
\concept{plot components}
