% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3JStext.R
\name{text3js}
\alias{text3js}
\title{Add text to a data3js object}
\usage{
text3js(
  data3js,
  x,
  y,
  z,
  text,
  size = NULL,
  col = "inherit",
  toggle = NULL,
  type = "geometry",
  alignment = "center",
  offset = c(0, 0),
  style = list(fontFamily = "sans-serif"),
  ...
)
}
\arguments{
\item{data3js}{The data3js object}

\item{x}{x coords}

\item{y}{y coords}

\item{z}{z coords}

\item{text}{character vector of text}

\item{size}{text size, if type is "geometry" this is interpreted in terms of
text height within the plotting space (default 1), if type is "html" then
this is interpreted as size in pts (default 16).}

\item{col}{text color}

\item{toggle}{associated text toggle button}

\item{type}{text type, either "geometry" or "html"}

\item{alignment}{text alignment, i.e. "left" "top" "topright"}

\item{offset}{onscreen text offset for html text, x then y}

\item{style}{named list of css style attributes to apply to the html text}

\item{...}{Additional attributes to pass to \code{material3js()}}
}
\value{
Returns an updated data3js object
}
\description{
The text added can either be as an html text object, superimposed on the scene
but moving relative to appear relative to the specified coordinqtes, or an actual
geometry, which will appear in the scene, zoom and rotate with it etc.
}
\examples{
# Set text parameters
x <- 1:4
y <- rep(0, 4)
z <- rep(0, 4)
labels <- LETTERS[1:4]
sizes <- c(0.4, 0.6, 0.8, 1)

# Create empty plot
p0 <- plot3js(
  xlim = c(0, 5),
  ylim = c(-1, 1),
  zlim = c(-1, 1),
  aspect = c(1, 1, 1),
  label_axes = FALSE
)

# Add text as a geometry
p <- text3js(
  data3js = p0,
  x = x,
  y = y,
  z = z,
  size = sizes,
  text = labels
)

r3js(p, rotation = c(0, 0, 0), zoom = 1)

# Add text as a html labels
p <- text3js(
  data3js = p0,
  x = x,
  y = y,
  z = z,
  size = sizes*40,
  text = labels,
  type = "html"
)

r3js(p, rotation = c(0, 0, 0), zoom = 1)

}
\seealso{
Other plot components: 
\code{\link{arrows3js}()},
\code{\link{axis3js}()},
\code{\link{box3js}()},
\code{\link{grid3js}()},
\code{\link{legend3js}()},
\code{\link{light3js}()},
\code{\link{lines3js}()},
\code{\link{mtext3js}()},
\code{\link{points3js}()},
\code{\link{segments3js}()},
\code{\link{shape3js}()},
\code{\link{sphere3js}()},
\code{\link{surface3js}()},
\code{\link{triangle3js}()}
}
\concept{plot components}
