% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getADMBHessian.R
\name{getADMBHessian}
\alias{getADMBHessian}
\title{Read admodel.hes file}
\usage{
getADMBHessian(File, FileName)
}
\arguments{
\item{File}{Directory in which .hes file is located.}

\item{FileName}{Name of .hes file.}
}
\value{
A list with elements num.pars, hes, hybrid_bounded_flag, and scale.
}
\description{
This function reads in all of the information contained in the
admodel.hes file. Some of this is needed for relaxing the
covariance matrix, and others just need to be recorded and
rewritten to file so ADMB "sees" what it's expecting.
}
\note{
Explanation of the methods (in PDF form) published here:
\url{https://github.com/admb-project/admb-examples/blob/master/admb-tricks/covariance-calculations/ADMB_Covariance_Calculations.pdf}
}
\seealso{
\code{\link{read.admbFit}}, \code{\link{NegLogInt_Fn}}
}
\author{
Cole Monnahan
}
