% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{altmetrics}
\alias{altmetrics}
\title{Query data from the Altmetric.com API}
\usage{
altmetrics(oid = NULL, id = NULL, doi = NULL, pmid = NULL,
  arxiv = NULL, isbn = NULL, uri = NULL,
  apikey = getOption("altmetricKey"), foptions = list(), ...)
}
\arguments{
\item{oid}{An object ID (assigned internally by Altmetric)}

\item{id}{An altmetric.com id for a scholarly product}

\item{doi}{A persistent identifier for a scholarly product}

\item{pmid}{An is for any article indexed in Pubmed. PubMed accesses the MEDLINE database of references and abstracts on life sciences and biomedical topics}

\item{arxiv}{A valid id from arxiv. The arxiv is a repository of preprints in the fields of mathematics, physics, astronomy, computer science, quantitative biology, statistics, and quantitative finance.}

\item{isbn}{A International Standard Book Number (ISBN)}

\item{uri}{A Uniform Resource Identifier such as webpage}

\item{apikey}{Your API `key`. By default the package ships with a key, but mostly as a demo. If the key becomes overused, then it is likely that you will start to see API limit errors}

\item{foptions}{Additional options for `httr`}

\item{...}{additional options}
}
\description{
Query data from the Altmetric.com API
}
\examples{
\dontrun{
altmetrics(doi ='10.1038/480426a')
# For ISBNs
ib <- altmetrics(isbn = "978-3-319-25557-6")
}
}
