% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_modules_timeSeries.R
\name{getTransformTS}
\alias{getTransformTS}
\title{Transform quantitative variables.}
\usage{
getTransformTS(data, col_date = "date",
  col_series = setdiff(colnames(data), col_date), ts = "10 min",
  tz = "UTC", fun_aggr = "mean", treat_missing = FALSE,
  control_date = TRUE, maxgap = Inf, keep_last = TRUE,
  type_aggr = "first", showwarn = FALSE)
}
\arguments{
\item{data}{: data.frame to transform}

\item{col_date}{: Date column name, default to "date".
Must be "POSIXct"}

\item{col_series}{: Column name of quantitative variable(s) to be
transformed. Default to setdiff(colnames(data), "date")}

\item{ts}{: Increment of the sequence. Default to "10 min".
Can be a number, in seconds, or a character string
containing one of "min", "hour", "day".
This can optionally be preceded by a positive integer
and a space}

\item{tz}{: Timezone of result. Defaut to "UTC".}

\item{fun_aggr}{: Aggregation function to use ("min", "max", "sum", "mean", "first", "last").
Default to "mean".}

\item{treat_missing}{: Boolean. Default to FALSE
Whether or not to interpolate missing values ?
see \code{na.approx}}

\item{control_date}{: Boolean. Control full data sequence ? Defaut to TRUE and set to TRUE if treat_missing}

\item{maxgap}{: When interpolate missing values with \code{na.approx}.
Maximum number of consecutive NAs to fill. Defaut to Inf.}

\item{keep_last}{: Boolean. Keep last date/time value after interpolation ?}

\item{type_aggr}{: Character. Type of aggregation
\itemize{
 \item{"first"}{ : Date/Time result is equal to minimum of sequence, and this minimum is included in aggregation}
 \item{"last"}{ : Date/Time result is equal to maximum of sequence, and this maximum is included in aggregation}
}}

\item{showwarn}{: Boolean. Show warnings ?}
}
\value{
a data.frame
}
\description{
Transform quantitative variables. Aggregate or interpolate time series data.
}
