% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSpeciesCode.R
\name{getSpeciesCode}
\alias{getSpeciesCode}
\title{Get BDAT species code or transform it to a name.}
\usage{
getSpeciesCode(inSp = NULL, outSp = NULL)
}
\arguments{
\item{inSp}{species information given, either numeric or character}

\item{outSp}{character vector of names, for which information should be returned}
}
\value{
vector or data.frame, depending on length of 'outSp'.
}
\description{
Function to get BDAT species code, or transform it to a
german or english name, possibly an abbreviated version or even a scientific
name
}
\details{
The function matches inSp to outSp. Depending on inSp, being either
a numeric vector of values between 1 and 36 or a character vector of species
names. Possible names are those which could be return values. One can get all
names and the respective species code by calling the function with inSP=NULL
and outSP=NULL (the default).

English species names and codes are taken from
https://www.forestry.gov.uk/pdf/PF2011_Tree_Species.pdf/$FILE/PF2011_Tree_Species.pdf
while slightly adjusting the codes to be unique compared to the german codes
(e.g. European larch is now ELA instead of EL).

Any given species code outside the interval [1, 36] is given the code 1
(i.e. Norway spruce), while throwing a warning. If any inSp - name is invalid,
i.e. not in species list, this throws an error.

All elements of outSp, which are not colnames of the default returned
data.frame, are silently dropped.
}
\examples{
getSpeciesCode(inSp = NULL, outSp = NULL) ## the default
getSpeciesCode() ## the same
getSpeciesCode(outSp = "scientific")
getSpeciesCode(inSp = c(1, 2)) ## giving codes
getSpeciesCode(inSp = c(1, 2, -1, 37)) ## values outside [1, 36] are given code 1
getSpeciesCode(inSp = c(1, 2), outSp = c("scientific")) ## output a vector
getSpeciesCode(inSp = c("Bu", "Fi")) ## asking for codes of abbreviated german names
getSpeciesCode(inSp = c("Bu", "Fi", "Bu")) ## order is preserved
getSpeciesCode(inSp = c("Buche", "Fichte")) ## asking for codes of german names
getSpeciesCode(inSp = c("BE", "NS")) ## ... abbreviated english names
getSpeciesCode(inSp = c("beech", "Norway spruce")) ## ... english names
getSpeciesCode(inSp = c("Fagus sylvatica", "Picea abies")) ### ... scientific names
}
