/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.velocity;

import org.springframework.boot.autoconfigure.template.TemplateAvailabilityProvider;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.ClassUtils;

public class VelocityTemplateAvailabilityProvider
implements TemplateAvailabilityProvider {
    @Override
    public boolean isTemplateAvailable(String view, Environment environment, ClassLoader classLoader, ResourceLoader resourceLoader) {
        if (ClassUtils.isPresent((String)"org.apache.velocity.app.VelocityEngine", (ClassLoader)classLoader)) {
            String loaderPath = environment.getProperty("spring.velocity.resourceLoaderPath", "classpath:/templates/");
            String prefix = environment.getProperty("spring.velocity.prefix", "");
            String suffix = environment.getProperty("spring.velocity.suffix", ".vm");
            return resourceLoader.getResource(loaderPath + prefix + view + suffix).exists();
        }
        return false;
    }
}

